/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.logsafe.Preconditions;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.slf4j.MDC;

final class LoggingContextHandler
implements HttpHandler {
    private final HttpHandler delegate;

    LoggingContextHandler(HttpHandler delegate) {
        this.delegate = (HttpHandler)Preconditions.checkNotNull((Object)delegate, (String)"Delegate handler is required");
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        MDC.clear();
        try {
            this.delegate.handleRequest(exchange);
        }
        finally {
            MDC.clear();
        }
    }
}

