/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.base.Suppliers;
import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.conjure.java.undertow.runtime.Encoding;
import com.palantir.logsafe.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Supplier;

final class LazilyInitializedEncoding
implements Encoding {
    private final Encoding delegate;

    LazilyInitializedEncoding(Encoding delegate) {
        this.delegate = (Encoding)Preconditions.checkNotNull((Object)delegate, (String)"Encoding is required");
    }

    @Override
    public <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
        return new LazilyInitializedSerializer(() -> this.delegate.serializer(type));
    }

    @Override
    public <T> Encoding.Serializer<T> serializer(TypeMarker<T> type, Endpoint endpoint) {
        return new LazilyInitializedSerializer(() -> this.delegate.serializer(type, endpoint));
    }

    @Override
    public <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
        return new LazilyInitializedDeserializer(() -> this.delegate.deserializer(type));
    }

    @Override
    public <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type, Endpoint endpoint) {
        return new LazilyInitializedDeserializer(() -> this.delegate.deserializer(type, endpoint));
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    @Override
    public boolean supportsContentType(String contentType) {
        return this.delegate.supportsContentType(contentType);
    }

    public String toString() {
        return "LazilyInitializedEncoding{delegate=" + String.valueOf(this.delegate) + "}";
    }

    private static final class LazilyInitializedSerializer<T>
    implements Encoding.Serializer<T> {
        private final Supplier<Encoding.Serializer<T>> delegate = Suppliers.memoize(delegate::get);

        LazilyInitializedSerializer(Supplier<Encoding.Serializer<T>> delegate) {
        }

        @Override
        public void serialize(T value, OutputStream output) throws IOException {
            this.delegate.get().serialize(value, output);
        }

        public String toString() {
            return "LazilyInitializedSerializer{" + String.valueOf(this.delegate) + "}";
        }
    }

    private static final class LazilyInitializedDeserializer<T>
    implements Encoding.Deserializer<T> {
        private final Supplier<Encoding.Deserializer<T>> delegate = Suppliers.memoize(delegate::get);

        LazilyInitializedDeserializer(Supplier<Encoding.Deserializer<T>> delegate) {
        }

        @Override
        public T deserialize(InputStream input) throws IOException {
            return this.delegate.get().deserialize(input);
        }

        public String toString() {
            return "LazilyInitializedDeserializer{" + String.valueOf(this.delegate) + "}";
        }
    }
}

