/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.conjure.java.undertow.lib.UndertowRuntime;
import com.palantir.conjure.java.undertow.lib.UndertowService;
import com.palantir.conjure.java.undertow.runtime.CompletedRequestTagTranslator;
import com.palantir.conjure.java.undertow.runtime.ConjureExceptionHandler;
import com.palantir.conjure.java.undertow.runtime.ConjureUndertowRuntime;
import com.palantir.conjure.java.undertow.runtime.DeprecationReportingResponseHandler;
import com.palantir.conjure.java.undertow.runtime.EndpointHandlerWrapper;
import com.palantir.conjure.java.undertow.runtime.EndpointTagTranslator;
import com.palantir.conjure.java.undertow.runtime.Endpoints;
import com.palantir.conjure.java.undertow.runtime.GlobRetainingDecodingHandler;
import com.palantir.conjure.java.undertow.runtime.LoggingContextHandler;
import com.palantir.conjure.java.undertow.runtime.NoCachingResponseHandler;
import com.palantir.conjure.java.undertow.runtime.OptionsHandler;
import com.palantir.conjure.java.undertow.runtime.WebSecurityHandler;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIllegalStateException;
import com.palantir.tracing.undertow.TracedRequestHandler;
import com.palantir.tracing.undertow.TracedStateHandler;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ConjureHandler
implements HttpHandler {
    private final RoutingHandler routingHandler;

    private ConjureHandler(HttpHandler fallback, List<Endpoint> endpoints) {
        this.routingHandler = Handlers.routing((boolean)false).setFallbackHandler(fallback).setInvalidMethodHandler(null);
        endpoints.forEach(this::register);
        ConjureHandler.registerSyntheticEndpoints(this.routingHandler, endpoints);
    }

    private static List<Endpoint> applyHeadEndpoints(RoutingHandler routingHandler, List<Endpoint> endpoints) {
        ArrayList<Endpoint> result = new ArrayList<Endpoint>(endpoints.size());
        for (Endpoint endpoint : endpoints) {
            result.add(endpoint);
            if (!Methods.GET.equals(endpoint.method())) continue;
            Endpoint headEndpoint = Endpoint.builder().from(endpoint).method(Methods.HEAD).build();
            result.add(headEndpoint);
            routingHandler.add(headEndpoint.method(), headEndpoint.template(), headEndpoint.handler());
        }
        return result;
    }

    private static void registerSyntheticEndpoints(RoutingHandler routingHandler, List<Endpoint> endpoints) {
        List<Endpoint> updatedEndpoints = ConjureHandler.applyHeadEndpoints(routingHandler, endpoints);
        ConjureHandler.registerOptionsEndpoints(routingHandler, updatedEndpoints);
    }

    private static void registerOptionsEndpoints(RoutingHandler routingHandler, List<Endpoint> endpoints) {
        ((ImmutableSetMultimap)endpoints.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(endpoint -> ConjureHandler.normalizeTemplate(endpoint.template()), Endpoint::method))).asMap().forEach((normalizedPath, methods) -> {
            if (!methods.contains(Methods.OPTIONS)) {
                routingHandler.add(Methods.OPTIONS, normalizedPath, (HttpHandler)new WebSecurityHandler(new OptionsHandler((Set<HttpString>)ImmutableSet.copyOf((Collection)methods))));
            }
        });
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.routingHandler.handleRequest(exchange);
    }

    private void register(Endpoint endpoint) {
        this.routingHandler.add(endpoint.method(), endpoint.template(), endpoint.handler());
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String normalizeTemplate(String template) {
        return template.replaceAll("\\{.*?\\}", "{param}");
    }

    public static final class Builder {
        private static final ImmutableSet<HttpString> ALLOWED_METHODS = ImmutableSet.of((Object)Methods.GET, (Object)Methods.PUT, (Object)Methods.POST, (Object)Methods.DELETE, (Object)Methods.OPTIONS, (Object)Methods.PATCH, (Object[])new HttpString[0]);
        private final List<EndpointHandlerWrapper> wrappersJustBeforeBlocking = new ArrayList<EndpointHandlerWrapper>();
        private final List<Endpoint> endpoints = new ArrayList<Endpoint>();
        private final List<UndertowService> services = new ArrayList<UndertowService>();
        private HttpHandler fallback = ResponseCodeHandler.HANDLE_404;
        private UndertowRuntime runtime = ConjureUndertowRuntime.builder().build();

        private Builder() {
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder endpoints(Endpoint value) {
            this.endpoints.add(Builder.checkEndpoint(value));
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addAllEndpoints(Iterable<Endpoint> values) {
            Preconditions.checkNotNull(values, (String)"Values is required");
            for (Endpoint endpoint : values) {
                this.endpoints(endpoint);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder services(UndertowService value) {
            this.services.add((UndertowService)Preconditions.checkNotNull((Object)value, (String)"Value is required"));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllServices(Iterable<? extends UndertowService> values) {
            Preconditions.checkNotNull(values, (String)"Values is required");
            for (UndertowService undertowService : values) {
                this.services(undertowService);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder fallback(HttpHandler value) {
            this.fallback = (HttpHandler)Preconditions.checkNotNull((Object)value, (String)"Value is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addWrapperBeforeBlocking(EndpointHandlerWrapper wrapper) {
            this.wrappersJustBeforeBlocking.add(wrapper);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder runtime(UndertowRuntime value) {
            this.runtime = (UndertowRuntime)Preconditions.checkNotNull((Object)value, (String)"UndertowRuntime");
            return this;
        }

        public HttpHandler build() {
            ImmutableList serviceEndpoints = (ImmutableList)this.services.stream().flatMap(service -> service.endpoints(this.runtime).stream()).map(Builder::checkEndpoint).collect(ImmutableList.toImmutableList());
            ImmutableList allEndpoints = ImmutableList.builder().addAll(this.endpoints).addAll((Iterable)serviceEndpoints).build();
            Builder.checkOverlappingPaths((List<Endpoint>)allEndpoints);
            ImmutableList wrappers = ImmutableList.builder().add((Object[])new EndpointHandlerWrapper[]{endpoint -> Optional.of(new TracedRequestHandler(endpoint.handler(), "Undertow: " + String.valueOf(endpoint.method()) + " " + endpoint.template(), CompletedRequestTagTranslator.INSTANCE.andThen(new EndpointTagTranslator(endpoint)))), GlobRetainingDecodingHandler.WRAPPER, endpoint -> Methods.GET.equals(endpoint.method()) ? Optional.of(new NoCachingResponseHandler(endpoint.handler())) : Optional.empty(), endpoint -> Optional.of(new WebSecurityHandler(endpoint.handler())), endpoint -> endpoint.deprecated().map(_reason -> new DeprecationReportingResponseHandler(endpoint.handler()))}).addAll(this.wrappersJustBeforeBlocking).add((Object[])new EndpointHandlerWrapper[]{endpoint -> Optional.of(new BlockingHandler(endpoint.handler())), endpoint -> Optional.of(new LoggingContextHandler(endpoint.handler())), endpoint -> Optional.of(new TracedStateHandler(endpoint.handler())), endpoint -> Optional.of(new ConjureExceptionHandler(endpoint.handler(), this.runtime.exceptionHandler()))}).build().reverse();
            return new ConjureHandler(this.fallback, (List)allEndpoints.stream().map(endpoint -> Builder.wrap(endpoint, (List<EndpointHandlerWrapper>)wrappers)).collect(ImmutableList.toImmutableList()));
        }

        private static Endpoint wrap(Endpoint input, List<EndpointHandlerWrapper> wrappers) {
            Endpoint current = input;
            for (EndpointHandlerWrapper wrapper : wrappers) {
                current = Endpoints.map(current, wrapper);
            }
            return current;
        }

        private static Endpoint checkEndpoint(Endpoint value) {
            Preconditions.checkNotNull((Object)value, (String)"Value is required");
            if (!ALLOWED_METHODS.contains((Object)value.method())) {
                throw new SafeIllegalStateException("Endpoint method is not recognized", new Arg[]{SafeArg.of((String)"method", (Object)value.method()), SafeArg.of((String)"template", (Object)value.template()), SafeArg.of((String)"service", (Object)value.serviceName()), SafeArg.of((String)"name", (Object)value.name())});
            }
            return value;
        }

        private static void checkOverlappingPaths(List<Endpoint> endpoints) {
            Set duplicates = endpoints.stream().collect(Collectors.groupingBy(endpoint -> String.format("%s: %s", endpoint.method(), ConjureHandler.normalizeTemplate(endpoint.template())))).entrySet().stream().filter(groups -> ((List)groups.getValue()).size() > 1).map(entry -> {
                String descriptions = ((List)entry.getValue()).stream().map(endpoint -> String.format("%s.%s", endpoint.serviceName(), endpoint.name())).collect(Collectors.joining(", "));
                return String.format("%s: %s", entry.getKey(), descriptions);
            }).collect(Collectors.toSet());
            if (!duplicates.isEmpty()) {
                throw new SafeIllegalArgumentException("The same route is declared by multiple UndertowServices", new Arg[]{SafeArg.of((String)"duplicates", duplicates)});
            }
        }
    }
}

