/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.util.concurrent.RateLimiter;
import com.palantir.conjure.java.api.errors.CheckedServiceException;
import com.palantir.conjure.java.api.errors.ConjureErrorParameterFormat;
import com.palantir.conjure.java.api.errors.ConjureErrorParameterFormats;
import com.palantir.conjure.java.api.errors.EndpointServiceException;
import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.QosException;
import com.palantir.conjure.java.api.errors.QosReason;
import com.palantir.conjure.java.api.errors.QosReasons;
import com.palantir.conjure.java.api.errors.RemoteException;
import com.palantir.conjure.java.api.errors.ServiceException;
import com.palantir.conjure.java.undertow.lib.ExceptionHandler;
import com.palantir.conjure.java.undertow.lib.Serializer;
import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.conjure.java.undertow.runtime.Attachments;
import com.palantir.conjure.java.undertow.runtime.ConjureBodySerDe;
import com.palantir.conjure.java.undertow.runtime.ConjureError;
import com.palantir.conjure.java.undertow.runtime.Encodings;
import com.palantir.conjure.java.undertow.runtime.FrameworkException;
import com.palantir.deadlines.DeadlineExpiredException;
import com.palantir.deadlines.DeadlineExpiredReasons;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import io.undertow.io.UndertowOutputStream;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.xnio.IoUtils;

public enum ConjureExceptions implements ExceptionHandler
{
    INSTANCE;

    private static final SafeLogger log;
    private static final Serializer<ConjureError> serializer;
    private static final RateLimiter qosLoggingRateLimiter;
    private static final QosException.Visitor<Integer> QOS_EXCEPTION_STATUS_CODE;
    private static final QosException.Visitor<Consumer<HttpServerExchange>> QOS_EXCEPTION_HEADERS;

    public void handle(HttpServerExchange exchange, Throwable throwable) {
        ConjureExceptions.setFailure(exchange, throwable);
        if (throwable instanceof EndpointServiceException) {
            EndpointServiceException endpointServiceException = (EndpointServiceException)throwable;
            ConjureExceptions.endpointServiceException(exchange, endpointServiceException);
        } else if (throwable instanceof CheckedServiceException) {
            CheckedServiceException checkedServiceException = (CheckedServiceException)throwable;
            ConjureExceptions.checkedServiceException(exchange, checkedServiceException);
        } else if (throwable instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)throwable;
            ConjureExceptions.serviceException(exchange, serviceException);
        } else if (throwable instanceof QosException) {
            QosException qosException = (QosException)throwable;
            ConjureExceptions.qosException(exchange, qosException);
        } else if (throwable instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)throwable;
            ConjureExceptions.remoteException(exchange, remoteException);
        } else if (throwable instanceof IllegalArgumentException) {
            ConjureExceptions.illegalArgumentException(exchange, throwable);
        } else if (throwable instanceof FrameworkException) {
            FrameworkException frameworkException = (FrameworkException)throwable;
            ConjureExceptions.frameworkException(exchange, frameworkException);
        } else if (throwable instanceof DeadlineExpiredException) {
            DeadlineExpiredException deadlineExpiredException = (DeadlineExpiredException)throwable;
            ConjureExceptions.deadlineExpiredException(exchange, deadlineExpiredException);
        } else if (throwable instanceof Error) {
            Error error = (Error)throwable;
            ConjureExceptions.error(exchange, error);
        } else if (throwable instanceof IOException && !exchange.getConnection().isOpen()) {
            log.info("I/O exception from a closed connection. The request may have been aborted by the client", throwable);
        } else {
            ServiceException exception = new ServiceException(ErrorType.INTERNAL, throwable, new Arg[0]);
            ConjureExceptions.log(exception, throwable);
            ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromServiceException(exception)), exception.getErrorType().httpErrorCode());
        }
    }

    private static void checkedServiceException(HttpServerExchange exchange, CheckedServiceException exception) {
        ConjureExceptions.log(exception);
        ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromCheckedServiceException(exception)), exception.getErrorType().httpErrorCode());
    }

    private static void endpointServiceException(HttpServerExchange exchange, EndpointServiceException exception) {
        ConjureExceptions.log(exception);
        ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromEndpointServiceException(exception)), exception.getErrorType().httpErrorCode());
    }

    private static void serviceException(HttpServerExchange exchange, ServiceException exception) {
        boolean isJsonErrorParameterValueFormat;
        Optional maybeErrorParamFormatHeader = ConjureErrorParameterFormats.parseFromRequest((Object)exchange.getRequestHeaders(), (ConjureErrorParameterFormats.ConjureErrorParameterFormatRequestDecodingAdapter)ConjureErrorParamsDecoder.INSTANCE);
        boolean isHeaderPresent = maybeErrorParamFormatHeader.isPresent();
        boolean bl = isJsonErrorParameterValueFormat = isHeaderPresent && ((ConjureErrorParameterFormat)maybeErrorParamFormatHeader.get()).toString().equalsIgnoreCase(ConjureErrorParameterFormat.JSON_FORMAT.toString());
        if (isHeaderPresent && !isJsonErrorParameterValueFormat) {
            log.info("Unrecognized Conjure error parameter format header", (Arg)SafeArg.of((String)"headerValue", (Object)((ConjureErrorParameterFormat)maybeErrorParamFormatHeader.get())));
        }
        ConjureExceptions.logWithSerializationFormat(exception, isJsonErrorParameterValueFormat);
        ConjureError conjureError = isJsonErrorParameterValueFormat ? ConjureError.fromServiceExceptionWithJsonSerializedParameterValues(exception) : ConjureError.fromServiceException(exception);
        ConjureExceptions.writeResponse(exchange, Optional.of(conjureError), exception.getErrorType().httpErrorCode());
    }

    private static void qosException(HttpServerExchange exchange, QosException qosException) {
        ((Consumer)qosException.accept(QOS_EXCEPTION_HEADERS)).accept(exchange);
        QosReasons.encodeToResponse((QosReason)qosException.getReason(), (Object)exchange, (QosReasons.QosResponseEncodingAdapter)UndertowQosResponseEncodingAdapter.INSTANCE);
        if (log.isDebugEnabled()) {
            log.debug("Quality-of-Service error handling request", (Throwable)qosException);
        } else if (ConjureExceptions.qosExceptionHasAdditionalMetadata(qosException) || qosLoggingRateLimiter.tryAcquire()) {
            log.info("Quality-of-Service error handling request", (Throwable)qosException);
        }
        ConjureExceptions.writeResponse(exchange, Optional.empty(), (Integer)qosException.accept(QOS_EXCEPTION_STATUS_CODE));
    }

    private static boolean qosExceptionHasAdditionalMetadata(QosException qosException) {
        try {
            if (qosException.getCause() != null) {
                return true;
            }
            Throwable[] suppressed = qosException.getSuppressed();
            return suppressed != null && suppressed.length > 1;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static void remoteException(HttpServerExchange exchange, RemoteException remoteException) {
        if (remoteException.getStatus() == 401 || remoteException.getStatus() == 403) {
            log.info("Encountered a remote exception", (Arg)SafeArg.of((String)"errorInstanceId", (Object)remoteException.getError().errorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)remoteException.getError().errorName()), (Arg)SafeArg.of((String)"statusCode", (Object)remoteException.getStatus()), (Throwable)remoteException);
            ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromRemoteException(remoteException)), remoteException.getStatus());
        } else {
            log.warn("Encountered a remote exception. Mapping to an internal error before propagating", (Arg)SafeArg.of((String)"errorInstanceId", (Object)remoteException.getError().errorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)remoteException.getError().errorName()), (Arg)SafeArg.of((String)"statusCode", (Object)remoteException.getStatus()), (Throwable)remoteException);
            ServiceException exception = new ServiceException(ErrorType.INTERNAL, (Throwable)remoteException, new Arg[0]);
            ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromServiceException(exception)), exception.getErrorType().httpErrorCode());
        }
    }

    private static void illegalArgumentException(HttpServerExchange exchange, Throwable throwable) {
        ServiceException exception = new ServiceException(ErrorType.INVALID_ARGUMENT, throwable, new Arg[0]);
        ConjureExceptions.log(exception, throwable);
        ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromServiceException(exception)), exception.getErrorType().httpErrorCode());
    }

    private static void frameworkException(HttpServerExchange exchange, FrameworkException frameworkException) {
        int statusCode = frameworkException.getStatusCode();
        ServiceException exception = new ServiceException(frameworkException.getErrorType(), (Throwable)frameworkException, new Arg[0]);
        ConjureExceptions.log(exception, frameworkException);
        ConjureExceptions.writeResponse(exchange, Optional.of(ConjureError.fromServiceException(exception)), statusCode);
    }

    private static void deadlineExpiredException(HttpServerExchange exchange, DeadlineExpiredException exception) {
        if (exception instanceof DeadlineExpiredException.Internal) {
            log.error("internal deadline exceeded", (Throwable)exception);
        } else {
            log.error("deadline exceeded", (Throwable)exception);
        }
        DeadlineExpiredReasons.encodeToResponse((DeadlineExpiredException)exception, (Object)exchange, (DeadlineExpiredReasons.ResponseEncodingAdapter)UndertowDeadlineReasonResponseEncodingAdapter.INSTANCE);
    }

    private static void error(HttpServerExchange exchange, Error error) {
        log.error("Error handling request", (Throwable)error);
        ConjureExceptions.writeResponse(exchange, Optional.empty(), ErrorType.INTERNAL.httpErrorCode());
    }

    private static void writeResponse(HttpServerExchange exchange, Optional<ConjureError> maybeBody, int statusCode) {
        if (!ConjureExceptions.isResponseStarted(exchange)) {
            exchange.setStatusCode(statusCode);
            if (maybeBody.isPresent()) {
                try {
                    serializer.serialize((Object)maybeBody.get(), exchange);
                }
                catch (IOException | RuntimeException e) {
                    log.info("Failed to write error response", (Throwable)e);
                }
            }
        } else {
            log.warn("Closing the connection to alert the client of an error");
            IoUtils.safeClose((Closeable)exchange.getConnection());
        }
    }

    private static boolean isResponseStarted(HttpServerExchange exchange) {
        if (exchange.isResponseStarted()) {
            return true;
        }
        OutputStream outputStream = exchange.getOutputStream();
        if (outputStream instanceof UndertowOutputStream) {
            UndertowOutputStream undertowOutputStream = (UndertowOutputStream)outputStream;
            undertowOutputStream.resetBuffer();
        }
        return false;
    }

    private static void logWithSerializationFormat(ServiceException serviceException, boolean isUsingJsonSerializationForParameters) {
        if (serviceException.getErrorType().httpErrorCode() / 100 == 4) {
            log.info("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)serviceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)serviceException.getErrorType().name()), (Arg)SafeArg.of((String)"isUsingJsonSerializationForParameters", (Object)isUsingJsonSerializationForParameters), (Throwable)serviceException);
        } else {
            log.error("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)serviceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)serviceException.getErrorType().name()), (Arg)SafeArg.of((String)"isUsingJsonSerializationForParameters", (Object)isUsingJsonSerializationForParameters), (Throwable)serviceException);
        }
    }

    private static void log(ServiceException serviceException, Throwable exceptionForLogging) {
        if (serviceException.getErrorType().httpErrorCode() / 100 == 4) {
            log.info("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)serviceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)serviceException.getErrorType().name()), exceptionForLogging);
        } else {
            log.error("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)serviceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)serviceException.getErrorType().name()), exceptionForLogging);
        }
    }

    private static void log(CheckedServiceException checkedServiceException) {
        if (checkedServiceException.getErrorType().httpErrorCode() / 100 == 4) {
            log.info("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)checkedServiceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)checkedServiceException.getErrorType().name()), (Throwable)checkedServiceException);
        } else {
            log.error("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)checkedServiceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)checkedServiceException.getErrorType().name()), (Throwable)checkedServiceException);
        }
    }

    private static void log(EndpointServiceException endpointServiceException) {
        if (endpointServiceException.getErrorType().httpErrorCode() / 100 == 4) {
            log.info("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)endpointServiceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)endpointServiceException.getErrorType().name()), (Throwable)endpointServiceException);
        } else {
            log.error("Error handling request", (Arg)SafeArg.of((String)"errorInstanceId", (Object)endpointServiceException.getErrorInstanceId()), (Arg)SafeArg.of((String)"errorName", (Object)endpointServiceException.getErrorType().name()), (Throwable)endpointServiceException);
        }
    }

    private static void setFailure(HttpServerExchange exchange, Throwable failure) {
        Throwable previous = (Throwable)exchange.putAttachment(Attachments.FAILURE, (Object)failure);
        if (previous != null) {
            exchange.putAttachment(Attachments.FAILURE, (Object)previous);
            log.info("Failure has already been set to a {} and will not be updated to the following", (Arg)SafeArg.of((String)"existingFailureType", previous.getClass()), failure);
        }
    }

    static {
        log = SafeLoggerFactory.get(ConjureExceptions.class);
        serializer = new ConjureBodySerDe(Collections.singletonList(Encodings.json())).serializer(new TypeMarker<ConjureError>(){});
        qosLoggingRateLimiter = RateLimiter.create((double)1.0);
        QOS_EXCEPTION_STATUS_CODE = new QosException.Visitor<Integer>(){

            public Integer visit(QosException.Throttle _exception) {
                return 429;
            }

            public Integer visit(QosException.RetryOther _exception) {
                return 308;
            }

            public Integer visit(QosException.Unavailable _exception) {
                return 503;
            }
        };
        QOS_EXCEPTION_HEADERS = new QosException.Visitor<Consumer<HttpServerExchange>>(){

            public Consumer<HttpServerExchange> visit(QosException.Throttle exception) {
                return exchange -> exception.getRetryAfter().ifPresent(duration -> exchange.getResponseHeaders().put(Headers.RETRY_AFTER, Long.toString(duration.get(ChronoUnit.SECONDS))));
            }

            public Consumer<HttpServerExchange> visit(QosException.RetryOther exception) {
                return exchange -> exchange.getResponseHeaders().put(Headers.LOCATION, exception.getRedirectTo().toString());
            }

            public Consumer<HttpServerExchange> visit(QosException.Unavailable _exception) {
                return _exchange -> {};
            }
        };
    }

    private static enum ConjureErrorParamsDecoder implements ConjureErrorParameterFormats.ConjureErrorParameterFormatRequestDecodingAdapter<HeaderMap>
    {
        INSTANCE;


        public String getFirstHeader(HeaderMap requestHeaderMap, String headerName) {
            return requestHeaderMap.getFirst(headerName);
        }
    }

    private static enum UndertowQosResponseEncodingAdapter implements QosReasons.QosResponseEncodingAdapter<HttpServerExchange>
    {
        INSTANCE;


        public void setHeader(HttpServerExchange exchange, String headerName, String headerValue) {
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)headerName), headerValue);
        }
    }

    private static enum UndertowDeadlineReasonResponseEncodingAdapter implements DeadlineExpiredReasons.ResponseEncodingAdapter<HttpServerExchange>
    {
        INSTANCE;


        public void setHeader(HttpServerExchange exchange, String headerName, String headerValue) {
            exchange.getResponseHeaders().put(HttpString.tryFromString((String)headerName), headerValue);
        }

        public void setStatus(HttpServerExchange exchange, int status) {
            ConjureExceptions.writeResponse(exchange, Optional.empty(), status);
        }
    }
}

