/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.google.common.collect.ImmutableList;
import com.palantir.conjure.java.api.config.service.ImmutableAgent;
import com.palantir.conjure.java.api.config.service.ImmutableUserAgent;
import com.palantir.conjure.java.api.config.service.UserAgents;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public interface UserAgent {
    @Value.Lazy
    default public Optional<@Safe String> nodeId() {
        if (this.primary().comments().isEmpty()) {
            return Optional.empty();
        }
        return this.primary().comments().stream().filter(item -> item.startsWith("nodeId:")).map(item -> item.substring(7).trim()).filter(UserAgents::isValidNodeId).findFirst();
    }

    public Agent primary();

    public List<Agent> informational();

    public static UserAgent of(Agent agent, @Safe String nodeId) {
        UserAgents.checkNodeId(nodeId);
        List<CallSite> comments = Stream.concat(agent.comments().stream().filter(item -> !item.startsWith("nodeId:")), Stream.of("nodeId:" + nodeId)).toList();
        return ImmutableUserAgent.builder().primary(Agent.of(agent.name(), agent.version(), comments)).build();
    }

    public static UserAgent of(Agent agent) {
        return ImmutableUserAgent.builder().primary(agent).build();
    }

    public static UserAgent of(UserAgent base, Iterable<Agent> additional) {
        return ImmutableUserAgent.builder().from(base).addAllInformational(additional).build();
    }

    default public UserAgent addAgent(Agent agent) {
        return ImmutableUserAgent.builder().from(this).addInformational(agent).build();
    }

    @Safe
    @Value.Immutable
    public static interface Agent {
        public static final String DEFAULT_VERSION = "0.0.0";

        @Safe
        public String name();

        @Safe
        public String version();

        public List<@Safe String> comments();

        @Value.Check
        default public void check() {
            if (!UserAgents.isValidName(this.name())) {
                throw new SafeIllegalArgumentException("Illegal agent name format", new Arg[]{SafeArg.of((String)"name", (Object)this.name())});
            }
            if (!UserAgents.isValidVersion(this.version())) {
                throw new SafeIllegalArgumentException("Illegal version format. This is a bug", new Arg[]{SafeArg.of((String)"version", (Object)this.version())});
            }
        }

        public static Agent of(@Safe String name, @Safe String version) {
            return ImmutableAgent.builder().name(name).version(UserAgents.isValidVersion(version) ? version : DEFAULT_VERSION).build();
        }

        public static Agent of(@Safe String name, @Safe String version, @Safe @Safe Iterable<@Safe String> comments) {
            ImmutableList immutableComments = ImmutableList.copyOf(comments);
            for (int i = 0; i < immutableComments.size(); ++i) {
                String comment = (String)immutableComments.get(i);
                UserAgents.checkComment(comment);
            }
            return ImmutableAgent.builder().name(name).version(UserAgents.isValidVersion(version) ? version : DEFAULT_VERSION).comments((Iterable<String>)immutableComments).build();
        }
    }
}

