/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.palantir.conjure.java.api.config.service.HumanReadableDuration;
import com.palantir.conjure.java.api.config.service.ImmutableServicesConfigBlock;
import com.palantir.conjure.java.api.config.service.PartialServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import com.palantir.logsafe.DoNotLog;
import com.palantir.tokens.auth.BearerToken;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;

@DoNotLog
@JsonSerialize(as=ImmutableServicesConfigBlock.class)
@JsonDeserialize(builder=Builder.class)
@Value.Immutable(singleton=true)
public abstract class ServicesConfigBlock {
    @JsonProperty(value="apiToken")
    @JsonAlias(value={"api-token"})
    @Value.Redacted
    public abstract Optional<BearerToken> defaultApiToken();

    @JsonProperty(value="security")
    public abstract Optional<SslConfiguration> defaultSecurity();

    @JsonProperty(value="services")
    public abstract Map<String, PartialServiceConfiguration> services();

    @JsonProperty(value="proxyConfiguration")
    @JsonAlias(value={"proxy-configuration"})
    public abstract Optional<ProxyConfiguration> defaultProxyConfiguration();

    @JsonProperty(value="connectTimeout")
    @JsonAlias(value={"connect-timeout"})
    public abstract Optional<HumanReadableDuration> defaultConnectTimeout();

    @JsonProperty(value="readTimeout")
    @JsonAlias(value={"read-timeout"})
    public abstract Optional<HumanReadableDuration> defaultReadTimeout();

    @JsonProperty(value="writeTimeout")
    @JsonAlias(value={"write-timeout"})
    public abstract Optional<HumanReadableDuration> defaultWriteTimeout();

    @JsonProperty(value="backoffSlotSize")
    @JsonAlias(value={"backoff-slot-size"})
    public abstract Optional<HumanReadableDuration> defaultBackoffSlotSize();

    @JsonProperty(value="enableGcmCipherSuites")
    @JsonAlias(value={"enable-gcm-cipher-suites"})
    public abstract Optional<Boolean> defaultEnableGcmCipherSuites();

    @JsonProperty(value="enableHttp2")
    @JsonAlias(value={"enable-http2"})
    public abstract Optional<Boolean> defaultEnableHttp2();

    @Deprecated
    @JsonProperty(value="fallbackToCommonNameVerification")
    @JsonAlias(value={"fallback-to-common-name-verification"})
    public abstract Optional<Boolean> defaultFallbackToCommonNameVerification();

    public static ServicesConfigBlock empty() {
        return ImmutableServicesConfigBlock.of();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableServicesConfigBlock.Builder {
    }
}

