/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.palantir.conjure.java.api.config.service.PartialServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ServicesConfigBlock;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ServiceConfigurationFactory {
    private final ServicesConfigBlock services;

    private ServiceConfigurationFactory(ServicesConfigBlock services) {
        this.services = services;
    }

    public static ServiceConfigurationFactory of(ServicesConfigBlock services) {
        return new ServiceConfigurationFactory(services);
    }

    public ServiceConfiguration get(String serviceName) {
        PartialServiceConfiguration partial = this.services.services().get(serviceName);
        Preconditions.checkNotNull((Object)partial, (String)"No configuration found for service", (Arg)SafeArg.of((String)"serviceName", (Object)serviceName));
        return this.propagateDefaults(serviceName, partial);
    }

    public Map<String, ServiceConfiguration> getAll() {
        HashMap<String, ServiceConfiguration> config = new HashMap<String, ServiceConfiguration>();
        this.services.services().forEach((key, value) -> config.put((String)key, this.propagateDefaults((String)key, (PartialServiceConfiguration)value)));
        return config;
    }

    public boolean isEnabled(String serviceName) {
        PartialServiceConfiguration serviceConfig = this.services.services().get(serviceName);
        return serviceConfig != null && !serviceConfig.uris().isEmpty();
    }

    private ServiceConfiguration propagateDefaults(String serviceName, PartialServiceConfiguration partial) {
        return ServiceConfiguration.builder().apiToken(ServiceConfigurationFactory.orElse(partial.apiToken(), this.services.defaultApiToken())).security(ServiceConfigurationFactory.orElse(partial.security(), this.services.defaultSecurity()).orElseThrow(() -> new SafeIllegalArgumentException("Must provide default security or service-specific security block for service", new Arg[]{SafeArg.of((String)"serviceName", (Object)serviceName)}))).uris(partial.uris()).connectTimeout(ServiceConfigurationFactory.orElse(partial.connectTimeout(), this.services.defaultConnectTimeout()).map(t -> Duration.ofMillis(t.toMilliseconds()))).readTimeout(ServiceConfigurationFactory.orElse(partial.readTimeout(), this.services.defaultReadTimeout()).map(t -> Duration.ofMillis(t.toMilliseconds()))).writeTimeout(ServiceConfigurationFactory.orElse(partial.writeTimeout(), this.services.defaultWriteTimeout()).map(t -> Duration.ofMillis(t.toMilliseconds()))).maxNumRetries(partial.maxNumRetries()).backoffSlotSize(ServiceConfigurationFactory.orElse(partial.backoffSlotSize(), this.services.defaultBackoffSlotSize()).map(t -> Duration.ofMillis(t.toMilliseconds()))).proxy(ServiceConfigurationFactory.orElse(partial.proxyConfiguration(), this.services.defaultProxyConfiguration())).enableGcmCipherSuites(ServiceConfigurationFactory.orElse(partial.enableGcmCipherSuites(), this.services.defaultEnableGcmCipherSuites())).enableHttp2(ServiceConfigurationFactory.orElse(partial.enableHttp2(), this.services.defaultEnableHttp2())).fallbackToCommonNameVerification(ServiceConfigurationFactory.orElse(partial.fallbackToCommonNameVerification(), this.services.defaultFallbackToCommonNameVerification())).build();
    }

    private static <T> Optional<T> orElse(Optional<T> first, Optional<T> second) {
        if (first.isPresent()) {
            return first;
        }
        return second;
    }
}

