/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.config.service.HumanReadableDuration;
import com.palantir.conjure.java.api.config.service.PartialServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import com.palantir.tokens.auth.BearerToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="PartialServiceConfiguration", generator="Immutables")
final class ImmutablePartialServiceConfiguration
implements PartialServiceConfiguration {
    private final BearerToken apiToken;
    private final SslConfiguration security;
    private final List<String> uris;
    private final HumanReadableDuration connectTimeout;
    private final HumanReadableDuration readTimeout;
    private final HumanReadableDuration writeTimeout;
    private final Integer maxNumRetries;
    private final HumanReadableDuration backoffSlotSize;
    private final Boolean enableGcmCipherSuites;
    private final Boolean enableHttp2;
    private final Boolean fallbackToCommonNameVerification;
    private final ProxyConfiguration proxyConfiguration;

    private ImmutablePartialServiceConfiguration(BearerToken apiToken, SslConfiguration security, List<String> uris, HumanReadableDuration connectTimeout, HumanReadableDuration readTimeout, HumanReadableDuration writeTimeout, Integer maxNumRetries, HumanReadableDuration backoffSlotSize, Boolean enableGcmCipherSuites, Boolean enableHttp2, Boolean fallbackToCommonNameVerification, ProxyConfiguration proxyConfiguration) {
        this.apiToken = apiToken;
        this.security = security;
        this.uris = uris;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.maxNumRetries = maxNumRetries;
        this.backoffSlotSize = backoffSlotSize;
        this.enableGcmCipherSuites = enableGcmCipherSuites;
        this.enableHttp2 = enableHttp2;
        this.fallbackToCommonNameVerification = fallbackToCommonNameVerification;
        this.proxyConfiguration = proxyConfiguration;
    }

    @Override
    @JsonProperty(value="apiToken")
    @JsonAlias(value={"api-token"})
    public Optional<BearerToken> apiToken() {
        return Optional.ofNullable(this.apiToken);
    }

    @Override
    @JsonProperty(value="security")
    public Optional<SslConfiguration> security() {
        return Optional.ofNullable(this.security);
    }

    @Override
    @JsonProperty(value="uris")
    public List<String> uris() {
        return this.uris;
    }

    @Override
    @JsonProperty(value="connectTimeout")
    @JsonAlias(value={"connect-timeout"})
    public Optional<HumanReadableDuration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    @JsonProperty(value="readTimeout")
    @JsonAlias(value={"read-timeout"})
    public Optional<HumanReadableDuration> readTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    @Override
    @JsonProperty(value="writeTimeout")
    @JsonAlias(value={"write-timeout"})
    public Optional<HumanReadableDuration> writeTimeout() {
        return Optional.ofNullable(this.writeTimeout);
    }

    @Override
    @JsonProperty(value="maxNumRetries")
    @JsonAlias(value={"max-num-retries"})
    public Optional<Integer> maxNumRetries() {
        return Optional.ofNullable(this.maxNumRetries);
    }

    @Override
    @JsonProperty(value="backoffSlotSize")
    @JsonAlias(value={"backoff-slot-size"})
    public Optional<HumanReadableDuration> backoffSlotSize() {
        return Optional.ofNullable(this.backoffSlotSize);
    }

    @Override
    @JsonProperty(value="enableGcmCipherSuites")
    @JsonAlias(value={"enable-gcm-cipher-suites"})
    public Optional<Boolean> enableGcmCipherSuites() {
        return Optional.ofNullable(this.enableGcmCipherSuites);
    }

    @Override
    @JsonProperty(value="enableHttp2")
    @JsonAlias(value={"enable-http2"})
    public Optional<Boolean> enableHttp2() {
        return Optional.ofNullable(this.enableHttp2);
    }

    @Override
    @JsonProperty(value="fallbackToCommonNameVerification")
    @JsonAlias(value={"fallback-to-common-name-verification"})
    @Deprecated
    public Optional<Boolean> fallbackToCommonNameVerification() {
        return Optional.ofNullable(this.fallbackToCommonNameVerification);
    }

    @Override
    @JsonProperty(value="proxyConfiguration")
    @JsonAlias(value={"proxy-configuration"})
    public Optional<ProxyConfiguration> proxyConfiguration() {
        return Optional.ofNullable(this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withApiToken(BearerToken value) {
        BearerToken newValue = Objects.requireNonNull(value, "apiToken");
        if (this.apiToken == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(newValue, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withApiToken(Optional<? extends BearerToken> optional) {
        BearerToken value = optional.orElse(null);
        if (this.apiToken == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(value, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withSecurity(SslConfiguration value) {
        SslConfiguration newValue = Objects.requireNonNull(value, "security");
        if (this.security == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, newValue, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withSecurity(Optional<? extends SslConfiguration> optional) {
        SslConfiguration value = optional.orElse(null);
        if (this.security == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, value, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withUris(String ... elements) {
        List<String> newValue = ImmutablePartialServiceConfiguration.createUnmodifiableList(false, ImmutablePartialServiceConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, newValue, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withUris(Iterable<String> elements) {
        if (this.uris == elements) {
            return this;
        }
        List<String> newValue = ImmutablePartialServiceConfiguration.createUnmodifiableList(false, ImmutablePartialServiceConfiguration.createSafeList(elements, true, false));
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, newValue, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withConnectTimeout(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "connectTimeout");
        if (this.connectTimeout == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, newValue, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withConnectTimeout(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.connectTimeout == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, value, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withReadTimeout(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "readTimeout");
        if (this.readTimeout == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, newValue, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withReadTimeout(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.readTimeout == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, value, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withWriteTimeout(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "writeTimeout");
        if (this.writeTimeout == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, newValue, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withWriteTimeout(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.writeTimeout == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, value, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withMaxNumRetries(int value) {
        Integer newValue = value;
        if (Objects.equals(this.maxNumRetries, newValue)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, newValue, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withMaxNumRetries(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.maxNumRetries, value)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, value, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withBackoffSlotSize(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "backoffSlotSize");
        if (this.backoffSlotSize == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, newValue, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withBackoffSlotSize(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.backoffSlotSize == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, value, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withEnableGcmCipherSuites(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableGcmCipherSuites, newValue)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, newValue, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withEnableGcmCipherSuites(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableGcmCipherSuites, value)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, value, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withEnableHttp2(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableHttp2, newValue)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, newValue, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withEnableHttp2(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableHttp2, value)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, value, this.fallbackToCommonNameVerification, this.proxyConfiguration);
    }

    @Deprecated
    public final ImmutablePartialServiceConfiguration withFallbackToCommonNameVerification(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.fallbackToCommonNameVerification, newValue)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, newValue, this.proxyConfiguration);
    }

    @Deprecated
    public final ImmutablePartialServiceConfiguration withFallbackToCommonNameVerification(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.fallbackToCommonNameVerification, value)) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, value, this.proxyConfiguration);
    }

    public final ImmutablePartialServiceConfiguration withProxyConfiguration(ProxyConfiguration value) {
        ProxyConfiguration newValue = Objects.requireNonNull(value, "proxyConfiguration");
        if (this.proxyConfiguration == newValue) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, newValue);
    }

    public final ImmutablePartialServiceConfiguration withProxyConfiguration(Optional<? extends ProxyConfiguration> optional) {
        ProxyConfiguration value = optional.orElse(null);
        if (this.proxyConfiguration == value) {
            return this;
        }
        return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePartialServiceConfiguration && this.equalsByValue((ImmutablePartialServiceConfiguration)another);
    }

    private boolean equalsByValue(ImmutablePartialServiceConfiguration another) {
        return Objects.equals(this.apiToken, another.apiToken) && Objects.equals(this.security, another.security) && this.uris.equals(another.uris) && Objects.equals(this.connectTimeout, another.connectTimeout) && Objects.equals(this.readTimeout, another.readTimeout) && Objects.equals(this.writeTimeout, another.writeTimeout) && Objects.equals(this.maxNumRetries, another.maxNumRetries) && Objects.equals(this.backoffSlotSize, another.backoffSlotSize) && Objects.equals(this.enableGcmCipherSuites, another.enableGcmCipherSuites) && Objects.equals(this.enableHttp2, another.enableHttp2) && Objects.equals(this.fallbackToCommonNameVerification, another.fallbackToCommonNameVerification) && Objects.equals(this.proxyConfiguration, another.proxyConfiguration);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.apiToken);
        h += (h << 5) + Objects.hashCode(this.security);
        h += (h << 5) + this.uris.hashCode();
        h += (h << 5) + Objects.hashCode(this.connectTimeout);
        h += (h << 5) + Objects.hashCode(this.readTimeout);
        h += (h << 5) + Objects.hashCode(this.writeTimeout);
        h += (h << 5) + Objects.hashCode(this.maxNumRetries);
        h += (h << 5) + Objects.hashCode(this.backoffSlotSize);
        h += (h << 5) + Objects.hashCode(this.enableGcmCipherSuites);
        h += (h << 5) + Objects.hashCode(this.enableHttp2);
        h += (h << 5) + Objects.hashCode(this.fallbackToCommonNameVerification);
        h += (h << 5) + Objects.hashCode(this.proxyConfiguration);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartialServiceConfiguration{");
        if (this.security != null) {
            if (builder.length() > 28) {
                builder.append(", ");
            }
            builder.append("security=").append(this.security);
        }
        if (builder.length() > 28) {
            builder.append(", ");
        }
        builder.append("uris=").append(this.uris);
        if (this.connectTimeout != null) {
            builder.append(", ");
            builder.append("connectTimeout=").append(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            builder.append(", ");
            builder.append("readTimeout=").append(this.readTimeout);
        }
        if (this.writeTimeout != null) {
            builder.append(", ");
            builder.append("writeTimeout=").append(this.writeTimeout);
        }
        if (this.maxNumRetries != null) {
            builder.append(", ");
            builder.append("maxNumRetries=").append(this.maxNumRetries);
        }
        if (this.backoffSlotSize != null) {
            builder.append(", ");
            builder.append("backoffSlotSize=").append(this.backoffSlotSize);
        }
        if (this.enableGcmCipherSuites != null) {
            builder.append(", ");
            builder.append("enableGcmCipherSuites=").append(this.enableGcmCipherSuites);
        }
        if (this.enableHttp2 != null) {
            builder.append(", ");
            builder.append("enableHttp2=").append(this.enableHttp2);
        }
        if (this.fallbackToCommonNameVerification != null) {
            builder.append(", ");
            builder.append("fallbackToCommonNameVerification=").append(this.fallbackToCommonNameVerification);
        }
        if (this.proxyConfiguration != null) {
            builder.append(", ");
            builder.append("proxyConfiguration=").append(this.proxyConfiguration);
        }
        return builder.append("}").toString();
    }

    public static PartialServiceConfiguration copyOf(PartialServiceConfiguration instance) {
        if (instance instanceof ImmutablePartialServiceConfiguration) {
            return (ImmutablePartialServiceConfiguration)instance;
        }
        return new PartialServiceConfiguration.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PartialServiceConfiguration", generator="Immutables")
    public static class Builder {
        private BearerToken apiToken;
        private SslConfiguration security;
        private List<String> uris = new ArrayList<String>();
        private HumanReadableDuration connectTimeout;
        private HumanReadableDuration readTimeout;
        private HumanReadableDuration writeTimeout;
        private Integer maxNumRetries;
        private HumanReadableDuration backoffSlotSize;
        private Boolean enableGcmCipherSuites;
        private Boolean enableHttp2;
        private Boolean fallbackToCommonNameVerification;
        private ProxyConfiguration proxyConfiguration;

        public Builder() {
            if (!(this instanceof PartialServiceConfiguration.Builder)) {
                throw new UnsupportedOperationException("Use: new PartialServiceConfiguration.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder from(PartialServiceConfiguration instance) {
            Optional<ProxyConfiguration> proxyConfigurationOptional;
            Optional<Boolean> fallbackToCommonNameVerificationOptional;
            Optional<Boolean> enableHttp2Optional;
            Optional<Boolean> enableGcmCipherSuitesOptional;
            Optional<HumanReadableDuration> backoffSlotSizeOptional;
            Optional<Integer> maxNumRetriesOptional;
            Optional<HumanReadableDuration> writeTimeoutOptional;
            Optional<HumanReadableDuration> readTimeoutOptional;
            Optional<SslConfiguration> securityOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<BearerToken> apiTokenOptional = instance.apiToken();
            if (apiTokenOptional.isPresent()) {
                this.apiToken(apiTokenOptional);
            }
            if ((securityOptional = instance.security()).isPresent()) {
                this.security(securityOptional);
            }
            this.addAllUris(instance.uris());
            Optional<HumanReadableDuration> connectTimeoutOptional = instance.connectTimeout();
            if (connectTimeoutOptional.isPresent()) {
                this.connectTimeout(connectTimeoutOptional);
            }
            if ((readTimeoutOptional = instance.readTimeout()).isPresent()) {
                this.readTimeout(readTimeoutOptional);
            }
            if ((writeTimeoutOptional = instance.writeTimeout()).isPresent()) {
                this.writeTimeout(writeTimeoutOptional);
            }
            if ((maxNumRetriesOptional = instance.maxNumRetries()).isPresent()) {
                this.maxNumRetries(maxNumRetriesOptional);
            }
            if ((backoffSlotSizeOptional = instance.backoffSlotSize()).isPresent()) {
                this.backoffSlotSize(backoffSlotSizeOptional);
            }
            if ((enableGcmCipherSuitesOptional = instance.enableGcmCipherSuites()).isPresent()) {
                this.enableGcmCipherSuites(enableGcmCipherSuitesOptional);
            }
            if ((enableHttp2Optional = instance.enableHttp2()).isPresent()) {
                this.enableHttp2(enableHttp2Optional);
            }
            if ((fallbackToCommonNameVerificationOptional = instance.fallbackToCommonNameVerification()).isPresent()) {
                this.fallbackToCommonNameVerification(fallbackToCommonNameVerificationOptional);
            }
            if ((proxyConfigurationOptional = instance.proxyConfiguration()).isPresent()) {
                this.proxyConfiguration(proxyConfigurationOptional);
            }
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder apiToken(BearerToken apiToken) {
            this.apiToken = Objects.requireNonNull(apiToken, "apiToken");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="apiToken")
        @JsonAlias(value={"api-token"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder apiToken(Optional<? extends BearerToken> apiToken) {
            this.apiToken = apiToken.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder security(SslConfiguration security) {
            this.security = Objects.requireNonNull(security, "security");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="security")
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder security(Optional<? extends SslConfiguration> security) {
            this.security = security.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder addUris(String element) {
            this.uris.add(Objects.requireNonNull(element, "uris element"));
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder addUris(String ... elements) {
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="uris")
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder uris(Iterable<String> elements) {
            this.uris.clear();
            return this.addAllUris(elements);
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder addAllUris(Iterable<String> elements) {
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder connectTimeout(HumanReadableDuration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="connectTimeout")
        @JsonAlias(value={"connect-timeout"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder connectTimeout(Optional<? extends HumanReadableDuration> connectTimeout) {
            this.connectTimeout = connectTimeout.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder readTimeout(HumanReadableDuration readTimeout) {
            this.readTimeout = Objects.requireNonNull(readTimeout, "readTimeout");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="readTimeout")
        @JsonAlias(value={"read-timeout"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder readTimeout(Optional<? extends HumanReadableDuration> readTimeout) {
            this.readTimeout = readTimeout.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder writeTimeout(HumanReadableDuration writeTimeout) {
            this.writeTimeout = Objects.requireNonNull(writeTimeout, "writeTimeout");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="writeTimeout")
        @JsonAlias(value={"write-timeout"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder writeTimeout(Optional<? extends HumanReadableDuration> writeTimeout) {
            this.writeTimeout = writeTimeout.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder maxNumRetries(int maxNumRetries) {
            this.maxNumRetries = maxNumRetries;
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="maxNumRetries")
        @JsonAlias(value={"max-num-retries"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder maxNumRetries(Optional<Integer> maxNumRetries) {
            this.maxNumRetries = maxNumRetries.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder backoffSlotSize(HumanReadableDuration backoffSlotSize) {
            this.backoffSlotSize = Objects.requireNonNull(backoffSlotSize, "backoffSlotSize");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="backoffSlotSize")
        @JsonAlias(value={"backoff-slot-size"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder backoffSlotSize(Optional<? extends HumanReadableDuration> backoffSlotSize) {
            this.backoffSlotSize = backoffSlotSize.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder enableGcmCipherSuites(boolean enableGcmCipherSuites) {
            this.enableGcmCipherSuites = enableGcmCipherSuites;
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="enableGcmCipherSuites")
        @JsonAlias(value={"enable-gcm-cipher-suites"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder enableGcmCipherSuites(Optional<Boolean> enableGcmCipherSuites) {
            this.enableGcmCipherSuites = enableGcmCipherSuites.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder enableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="enableHttp2")
        @JsonAlias(value={"enable-http2"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder enableHttp2(Optional<Boolean> enableHttp2) {
            this.enableHttp2 = enableHttp2.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder fallbackToCommonNameVerification(boolean fallbackToCommonNameVerification) {
            this.fallbackToCommonNameVerification = fallbackToCommonNameVerification;
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="fallbackToCommonNameVerification")
        @JsonAlias(value={"fallback-to-common-name-verification"})
        @Deprecated
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder fallbackToCommonNameVerification(Optional<Boolean> fallbackToCommonNameVerification) {
            this.fallbackToCommonNameVerification = fallbackToCommonNameVerification.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration, "proxyConfiguration");
            return (PartialServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="proxyConfiguration")
        @JsonAlias(value={"proxy-configuration"})
        @CanIgnoreReturnValue
        public final PartialServiceConfiguration.Builder proxyConfiguration(Optional<? extends ProxyConfiguration> proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration.orElse(null);
            return (PartialServiceConfiguration.Builder)this;
        }

        public PartialServiceConfiguration build() {
            return new ImmutablePartialServiceConfiguration(this.apiToken, this.security, ImmutablePartialServiceConfiguration.createUnmodifiableList(true, this.uris), this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxyConfiguration);
        }
    }
}

