/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;

public final class HostAndPort {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;

    private HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    boolean hasPort() {
        return this.port >= 0;
    }

    public static HostAndPort fromString(String hostPortString) {
        String host;
        Preconditions.checkNotNull((Object)hostPortString, (String)"hostPortString");
        String portString = null;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = HostAndPort.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
            }
        }
        int port = -1;
        if (portString != null && portString.length() > 0) {
            Preconditions.checkArgument((!portString.startsWith("+") ? 1 : 0) != 0, (String)"Unparseable port number", (Arg)SafeArg.of((String)"hostPort", (Object)hostPortString));
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new SafeIllegalArgumentException("Unparseable port number", (Throwable)e, new Arg[]{SafeArg.of((String)"hostPort", (Object)hostPortString)});
            }
            Preconditions.checkArgument((boolean)HostAndPort.isValidPort(port), (String)"Port number out of range", (Arg)SafeArg.of((String)"hostPort", (Object)hostPortString));
        }
        return new HostAndPort(host, port);
    }

    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        Preconditions.checkArgument((hostPortString.charAt(0) == '[' ? 1 : 0) != 0, (String)"Bracketed host-port string must start with a bracket", (Arg)SafeArg.of((String)"hostPort", (Object)hostPortString));
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        Preconditions.checkArgument((colonIndex > -1 && closeBracketIndex > colonIndex ? 1 : 0) != 0, (String)"Invalid bracketed host/port", (Arg)SafeArg.of((String)"hostPort", (Object)hostPortString));
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        Preconditions.checkArgument((hostPortString.charAt(closeBracketIndex + 1) == ':' ? 1 : 0) != 0, (String)"Only a colon may follow a close bracket", (Arg)SafeArg.of((String)"hostPort", (Object)hostPortString));
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            Preconditions.checkArgument((boolean)Character.isDigit(hostPortString.charAt(i)), (String)"Port must be numeric", (Arg)SafeArg.of((String)"hostPort", (Object)hostPortString));
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (this.host.indexOf(58) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.hasPort()) {
            builder.append(':').append(this.port);
        }
        return builder.toString();
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

