/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.google.errorprone.annotations.Immutable;

@Immutable
final class VersionParser {
    private static final long INT_MASK = 0xFFFFFFFFL;
    private static final int PARSE_FAILED = Integer.MIN_VALUE;

    private VersionParser() {
    }

    public static int countNumericDotGroups(String string) {
        long state = 0L;
        int i = 1;
        while (VersionParser.getIndex(state) < string.length()) {
            if (VersionParser.failed(state = VersionParser.number(string, VersionParser.getIndex(state)))) {
                return -1;
            }
            if (VersionParser.failed(state = VersionParser.literalDot(string, VersionParser.getIndex(state)))) {
                if (VersionParser.getIndex(state) < string.length()) {
                    return -1;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    static long number(String string, int startIndex) {
        int codepoint;
        int next;
        int len = string.length();
        for (next = startIndex; next < len && Character.isDigit(codepoint = string.codePointAt(next)); ++next) {
        }
        if (next == startIndex) {
            return VersionParser.fail(startIndex);
        }
        if (next == startIndex + 1) {
            return VersionParser.ok(next, Character.digit(string.codePointAt(startIndex), 10));
        }
        try {
            int result = Integer.parseUnsignedInt(string, startIndex, next, 10);
            if (result < 0) {
                return VersionParser.fail(startIndex);
            }
            return VersionParser.ok(next, result);
        }
        catch (NumberFormatException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("exceeds range of unsigned int.")) {
                return VersionParser.fail(startIndex);
            }
            throw e;
        }
    }

    static long literalDot(String string, int startIndex) {
        if (startIndex < string.length() && string.codePointAt(startIndex) == 46) {
            return VersionParser.ok(startIndex + 1, 0);
        }
        return VersionParser.fail(startIndex);
    }

    static long ok(int index, int result) {
        return (long)index << 32 | (long)result & 0xFFFFFFFFL;
    }

    static long fail(int index) {
        return (long)index << 32 | 0x80000000L;
    }

    static boolean isOk(long state) {
        return VersionParser.getResult(state) != Integer.MIN_VALUE;
    }

    static boolean failed(long state) {
        return !VersionParser.isOk(state);
    }

    static int getResult(long state) {
        return (int)(state & 0xFFFFFFFFL);
    }

    static int getIndex(long state) {
        return (int)(state >>> 32);
    }
}

