/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.palantir.conjure.java.api.config.service.ImmutableUserAgent;
import com.palantir.conjure.java.api.config.service.UserAgent;
import com.palantir.conjure.java.api.config.service.VersionParser;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UserAgents {
    public static final String CONJURE_AGENT_NAME = "conjure-java-runtime";
    private static final SafeLogger log = SafeLoggerFactory.get(UserAgents.class);
    static final Pattern NAME_REGEX = Pattern.compile("[a-zA-Z][a-zA-Z0-9\\-]*");
    private static final Pattern LENIENT_VERSION_REGEX = Pattern.compile("[0-9a-z.-]+");
    private static final Pattern NODE_REGEX = Pattern.compile("[a-zA-Z0-9][a-zA-Z0-9.\\-]*");
    private static final Pattern VERSION_REGEX = Pattern.compile("^[0-9]+(?:\\.[0-9]+)*(?:-rc[0-9]+)?(?:-[0-9]+-g[a-f0-9]+)?$");
    private static final Pattern SEGMENT_PATTERN = Pattern.compile(String.format("(%s)/(%s)( \\((.+?)\\))?", NAME_REGEX, LENIENT_VERSION_REGEX));
    private static final Splitter SEMICOLON_SPLITTER = Splitter.on((CharMatcher)CharMatcher.is((char)';').precomputed()).trimResults().omitEmptyStrings();
    private static final CharMatcher COMMENT_VALID_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-:_/ ,")).precomputed();

    private UserAgents() {
    }

    @Safe
    public static String format(@Safe UserAgent userAgent) {
        StringBuilder formatted = new StringBuilder(64);
        UserAgents.formatSimpleAgent(userAgent.primary(), formatted);
        for (UserAgent.Agent informationalAgent : userAgent.informational()) {
            formatted.append(' ');
            UserAgents.formatSimpleAgent(informationalAgent, formatted);
        }
        return formatted.toString();
    }

    private static void formatSimpleAgent(UserAgent.Agent agent, StringBuilder output) {
        output.ensureCapacity(output.length() + 1 + agent.name().length() + agent.version().length());
        output.append(agent.name()).append('/').append(agent.version());
        List<String> comments = agent.comments();
        if (!comments.isEmpty()) {
            output.append(" (");
            for (int i = 0; i < comments.size(); ++i) {
                if (i > 0) {
                    output.append("; ");
                }
                output.append(comments.get(i));
            }
            output.append(')');
        }
    }

    public static UserAgent parse(@Safe String userAgent) {
        Preconditions.checkNotNull((Object)userAgent, (String)"userAgent must not be null");
        return UserAgents.parseInternal(userAgent, false);
    }

    public static UserAgent tryParse(@Safe String userAgent) {
        return UserAgents.parseInternal(userAgent == null ? "" : userAgent, true);
    }

    public static String tryParsePrimaryName(@Safe String userAgent) {
        int lindex;
        if (userAgent == null) {
            return "unknown";
        }
        int split = userAgent.indexOf(47);
        if (split <= 0) {
            return "unknown";
        }
        for (lindex = split - 1; lindex >= 0 && UserAgents.isValidCharForName(userAgent.charAt(lindex)); --lindex) {
        }
        if (++lindex == split) {
            return "unknown";
        }
        if (!UserAgents.isAlpha(userAgent.charAt(lindex))) {
            return "unknown";
        }
        return userAgent.substring(lindex, split);
    }

    private static UserAgent parseInternal(@Safe String userAgent, boolean lenient) {
        ImmutableUserAgent.Builder builder = ImmutableUserAgent.builder();
        Matcher matcher = SEGMENT_PATTERN.matcher(userAgent);
        boolean foundFirst = false;
        while (matcher.find()) {
            String name = matcher.group(1);
            String version = matcher.group(2);
            Optional<String> comments = Optional.ofNullable(matcher.group(4));
            UserAgent.Agent agent = UserAgent.Agent.of(name, version, comments.map(UserAgents::parseComments).orElseGet(ImmutableList::of));
            if (!foundFirst) {
                builder.primary(agent);
            } else {
                builder.addInformational(agent);
            }
            foundFirst = true;
        }
        if (!foundFirst) {
            if (lenient) {
                if (log.isDebugEnabled()) {
                    log.debug("Invalid user agent '{}', falling back to default/unknown agent", (Arg)SafeArg.of((String)"userAgent", (Object)userAgent));
                }
                return builder.primary(UserAgent.Agent.of("unknown", "0.0.0")).build();
            }
            throw new SafeIllegalArgumentException("Failed to parse user agent string", new Arg[]{SafeArg.of((String)"userAgent", (Object)userAgent)});
        }
        return builder.build();
    }

    private static List<String> parseComments(String commentsString) {
        List results = SEMICOLON_SPLITTER.splitToList((CharSequence)commentsString);
        for (int i = 0; i < results.size(); ++i) {
            if (UserAgents.isValidComment((String)results.get(i))) continue;
            return results.stream().filter(UserAgents::isValidComment).toList();
        }
        return results;
    }

    static void checkComment(@Safe String comment) {
        if (comment == null) {
            throw new SafeIllegalArgumentException("Comment must not be null", new Arg[0]);
        }
        if (comment.isEmpty()) {
            throw new SafeIllegalArgumentException("Comment must not be empty", new Arg[0]);
        }
        if (comment.startsWith(" ")) {
            throw new SafeIllegalArgumentException("Comment must not start with whitespace", new Arg[]{SafeArg.of((String)"comment", (Object)comment)});
        }
        if (comment.endsWith(" ")) {
            throw new SafeIllegalArgumentException("Comment must not end with whitespace", new Arg[]{SafeArg.of((String)"comment", (Object)comment)});
        }
        if (!COMMENT_VALID_CHARS.matchesAllOf((CharSequence)comment)) {
            throw new SafeIllegalArgumentException("Comment contains disallowed characters", new Arg[]{SafeArg.of((String)"allowed", (Object)"a-zA-Z0-9.-:_/ "), SafeArg.of((String)"comment", (Object)comment)});
        }
    }

    static boolean isValidComment(@Safe String comment) {
        return comment != null && !comment.isEmpty() && !comment.startsWith(" ") && !comment.endsWith(" ") && COMMENT_VALID_CHARS.matchesAllOf((CharSequence)comment);
    }

    static boolean isValidName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        char ch = name.charAt(0);
        if (!UserAgents.isAlpha(ch)) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if (UserAgents.isValidCharForName(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidCharForName(char ch) {
        return UserAgents.isAlpha(ch) || UserAgents.isNumeric(ch) || ch == '-';
    }

    private static boolean isAlpha(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z';
    }

    private static boolean isNumeric(char ch) {
        return '0' <= ch && ch <= '9';
    }

    static boolean isValidNodeId(String instanceId) {
        return NODE_REGEX.matcher(instanceId).matches();
    }

    static void checkNodeId(@Safe String instanceId) {
        if (!UserAgents.isValidNodeId(instanceId)) {
            throw new SafeIllegalArgumentException("Illegal node id format", new Arg[]{SafeArg.of((String)"nodeId", (Object)instanceId)});
        }
    }

    static boolean isValidVersion(@Safe String version) {
        if (VersionParser.countNumericDotGroups(version) >= 2 || UserAgents.versionMatchesRegex(version)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Encountered invalid user agent version '{}'", (Arg)SafeArg.of((String)"version", (Object)version));
        }
        return false;
    }

    static boolean versionMatchesRegex(String version) {
        return VERSION_REGEX.matcher(version).matches();
    }
}

