/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.computemodules.functions.serde;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.palantir.computemodules.functions.results.Failed;
import com.palantir.computemodules.functions.results.Ok;
import com.palantir.computemodules.functions.results.Result;
import com.palantir.computemodules.functions.serde.Serializer;
import com.palantir.logsafe.Unsafe;
import java.io.ByteArrayInputStream;

public final class DefaultSerializer<O>
implements Serializer<O> {
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    @Unsafe
    public Result serialize(String jobId, O output) {
        try {
            return new Ok(jobId, new ByteArrayInputStream(mapper.writeValueAsBytes(output)));
        }
        catch (JsonProcessingException exception) {
            return new Failed(jobId, (Exception)((Object)exception));
        }
    }
}

