/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.SortOrder;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestErrorsRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String compartmentId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"workRequestId", "compartmentId", "opcRequestId", "page", "limit", "sortOrder"})
    ListWorkRequestErrorsRequest(String workRequestId, String compartmentId, String opcRequestId, String page, Integer limit, SortOrder sortOrder) {
        this.workRequestId = workRequestId;
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestErrorsRequest, Void> {
        private String workRequestId;
        private String compartmentId;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestErrorsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestErrorsRequest build() {
            ListWorkRequestErrorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListWorkRequestErrorsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestErrorsRequest(this.workRequestId, this.compartmentId, this.opcRequestId, this.page, this.limit, this.sortOrder);
        }

        public String toString() {
            return "ListWorkRequestErrorsRequest.Builder(workRequestId=" + this.workRequestId + ", compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }
}

