/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.model.SenderInvitationStatus;
import com.oracle.bmc.tenantmanagercontrolplane.model.SortOrder;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListSenderInvitationsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String recipientTenancyId;
    private LifecycleState lifecycleState;
    private SenderInvitationStatus status;
    private String displayName;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"compartmentId", "recipientTenancyId", "lifecycleState", "status", "displayName", "opcRequestId", "page", "limit", "sortBy", "sortOrder"})
    ListSenderInvitationsRequest(String compartmentId, String recipientTenancyId, LifecycleState lifecycleState, SenderInvitationStatus status, String displayName, String opcRequestId, String page, Integer limit, SortBy sortBy, SortOrder sortOrder) {
        this.compartmentId = compartmentId;
        this.recipientTenancyId = recipientTenancyId;
        this.lifecycleState = lifecycleState;
        this.status = status;
        this.displayName = displayName;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getRecipientTenancyId() {
        return this.recipientTenancyId;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SenderInvitationStatus getStatus() {
        return this.status;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSenderInvitationsRequest, Void> {
        private String compartmentId;
        private String recipientTenancyId;
        private LifecycleState lifecycleState;
        private SenderInvitationStatus status;
        private String displayName;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSenderInvitationsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.recipientTenancyId(o.getRecipientTenancyId());
            this.lifecycleState(o.getLifecycleState());
            this.status(o.getStatus());
            this.displayName(o.getDisplayName());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSenderInvitationsRequest build() {
            ListSenderInvitationsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder recipientTenancyId(String recipientTenancyId) {
            this.recipientTenancyId = recipientTenancyId;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder status(SenderInvitationStatus status) {
            this.status = status;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListSenderInvitationsRequest buildWithoutInvocationCallback() {
            return new ListSenderInvitationsRequest(this.compartmentId, this.recipientTenancyId, this.lifecycleState, this.status, this.displayName, this.opcRequestId, this.page, this.limit, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListSenderInvitationsRequest.Builder(compartmentId=" + this.compartmentId + ", recipientTenancyId=" + this.recipientTenancyId + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", status=" + (Object)((Object)this.status) + ", displayName=" + this.displayName + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortBy {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

