/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.tenantmanagercontrolplane.RecipientInvitationAsync;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.AcceptRecipientInvitationConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.GetRecipientInvitationConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.IgnoreRecipientInvitationConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.ListRecipientInvitationsConverter;
import com.oracle.bmc.tenantmanagercontrolplane.internal.http.UpdateRecipientInvitationConverter;
import com.oracle.bmc.tenantmanagercontrolplane.requests.AcceptRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.IgnoreRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.ListRecipientInvitationsRequest;
import com.oracle.bmc.tenantmanagercontrolplane.requests.UpdateRecipientInvitationRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.AcceptRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.IgnoreRecipientInvitationResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.ListRecipientInvitationsResponse;
import com.oracle.bmc.tenantmanagercontrolplane.responses.UpdateRecipientInvitationResponse;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipientInvitationAsyncClient
implements RecipientInvitationAsync {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientInvitationAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("RECIPIENTINVITATION").serviceEndpointPrefix("").serviceEndpointTemplate("https://organizations.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public RecipientInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public RecipientInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public RecipientInvitationAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public RecipientInvitationAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AcceptRecipientInvitationResponse> acceptRecipientInvitation(AcceptRecipientInvitationRequest request, AsyncHandler<AcceptRecipientInvitationRequest, AcceptRecipientInvitationResponse> handler) {
        LOG.trace("Called async acceptRecipientInvitation");
        AcceptRecipientInvitationRequest interceptedRequest = AcceptRecipientInvitationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AcceptRecipientInvitationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AcceptRecipientInvitationResponse> transformer = AcceptRecipientInvitationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AcceptRecipientInvitationRequest, AcceptRecipientInvitationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AcceptRecipientInvitationRequest, AcceptRecipientInvitationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRecipientInvitationResponse> getRecipientInvitation(GetRecipientInvitationRequest request, AsyncHandler<GetRecipientInvitationRequest, GetRecipientInvitationResponse> handler) {
        LOG.trace("Called async getRecipientInvitation");
        GetRecipientInvitationRequest interceptedRequest = GetRecipientInvitationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRecipientInvitationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRecipientInvitationResponse> transformer = GetRecipientInvitationConverter.fromResponse();
        AsyncHandler<GetRecipientInvitationRequest, GetRecipientInvitationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRecipientInvitationRequest, GetRecipientInvitationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<IgnoreRecipientInvitationResponse> ignoreRecipientInvitation(IgnoreRecipientInvitationRequest request, AsyncHandler<IgnoreRecipientInvitationRequest, IgnoreRecipientInvitationResponse> handler) {
        LOG.trace("Called async ignoreRecipientInvitation");
        IgnoreRecipientInvitationRequest interceptedRequest = IgnoreRecipientInvitationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = IgnoreRecipientInvitationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, IgnoreRecipientInvitationResponse> transformer = IgnoreRecipientInvitationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<IgnoreRecipientInvitationRequest, IgnoreRecipientInvitationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<IgnoreRecipientInvitationRequest, IgnoreRecipientInvitationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRecipientInvitationsResponse> listRecipientInvitations(ListRecipientInvitationsRequest request, AsyncHandler<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse> handler) {
        LOG.trace("Called async listRecipientInvitations");
        ListRecipientInvitationsRequest interceptedRequest = ListRecipientInvitationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRecipientInvitationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRecipientInvitationsResponse> transformer = ListRecipientInvitationsConverter.fromResponse();
        AsyncHandler<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRecipientInvitationsRequest, ListRecipientInvitationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRecipientInvitationResponse> updateRecipientInvitation(UpdateRecipientInvitationRequest request, AsyncHandler<UpdateRecipientInvitationRequest, UpdateRecipientInvitationResponse> handler) {
        LOG.trace("Called async updateRecipientInvitation");
        UpdateRecipientInvitationRequest interceptedRequest = UpdateRecipientInvitationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRecipientInvitationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRecipientInvitationResponse> transformer = UpdateRecipientInvitationConverter.fromResponse();
        AsyncHandler<UpdateRecipientInvitationRequest, UpdateRecipientInvitationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRecipientInvitationRequest, UpdateRecipientInvitationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, RecipientInvitationAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public RecipientInvitationAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new RecipientInvitationAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

