/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.tenantmanagercontrolplane;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.tenantmanagercontrolplane.Link;
import com.oracle.bmc.tenantmanagercontrolplane.model.LifecycleState;
import com.oracle.bmc.tenantmanagercontrolplane.requests.GetLinkRequest;
import com.oracle.bmc.tenantmanagercontrolplane.responses.GetLinkResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class LinkWaiters {
    private final ExecutorService executorService;
    private final Link client;

    public Waiter<GetLinkRequest, GetLinkResponse> forLink(GetLinkRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLink(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLinkRequest, GetLinkResponse> forLink(GetLinkRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLink(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLinkRequest, GetLinkResponse> forLink(GetLinkRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLink(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLinkRequest, GetLinkResponse> forLink(BmcGenericWaiter waiter, GetLinkRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetLinkRequest, GetLinkResponse>(){

            public GetLinkResponse apply(GetLinkRequest request) {
                return LinkWaiters.this.client.getLink(request);
            }
        }, (Predicate)new Predicate<GetLinkResponse>(){

            public boolean apply(GetLinkResponse response) {
                return targetStatesSet.contains((Object)response.getLink().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Terminated)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public LinkWaiters(ExecutorService executorService, Link client) {
        this.executorService = executorService;
        this.client = client;
    }
}

