/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.oda.model.WorkRequestResource;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequest {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="odaInstanceId")
    private final String odaInstanceId;
    @JsonProperty(value="requestAction")
    private final RequestAction requestAction;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="statusMessage")
    private final String statusMessage;
    @JsonProperty(value="resources")
    private final List<WorkRequestResource> resources;
    @JsonProperty(value="percentComplete")
    private final Float percentComplete;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).compartmentId(this.compartmentId).odaInstanceId(this.odaInstanceId).requestAction(this.requestAction).status(this.status).statusMessage(this.statusMessage).resources(this.resources).percentComplete(this.percentComplete).timeAccepted(this.timeAccepted).timeStarted(this.timeStarted).timeFinished(this.timeFinished);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public RequestAction getRequestAction() {
        return this.requestAction;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public List<WorkRequestResource> getResources() {
        return this.resources;
    }

    public Float getPercentComplete() {
        return this.percentComplete;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkRequest)) {
            return false;
        }
        WorkRequest other = (WorkRequest)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$odaInstanceId = this.getOdaInstanceId();
        String other$odaInstanceId = other.getOdaInstanceId();
        if (this$odaInstanceId == null ? other$odaInstanceId != null : !this$odaInstanceId.equals(other$odaInstanceId)) {
            return false;
        }
        RequestAction this$requestAction = this.getRequestAction();
        RequestAction other$requestAction = other.getRequestAction();
        if (this$requestAction == null ? other$requestAction != null : !((Object)((Object)this$requestAction)).equals((Object)other$requestAction)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$statusMessage = this.getStatusMessage();
        String other$statusMessage = other.getStatusMessage();
        if (this$statusMessage == null ? other$statusMessage != null : !this$statusMessage.equals(other$statusMessage)) {
            return false;
        }
        List<WorkRequestResource> this$resources = this.getResources();
        List<WorkRequestResource> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Float this$percentComplete = this.getPercentComplete();
        Float other$percentComplete = other.getPercentComplete();
        if (this$percentComplete == null ? other$percentComplete != null : !((Object)this$percentComplete).equals(other$percentComplete)) {
            return false;
        }
        Date this$timeAccepted = this.getTimeAccepted();
        Date other$timeAccepted = other.getTimeAccepted();
        if (this$timeAccepted == null ? other$timeAccepted != null : !((Object)this$timeAccepted).equals(other$timeAccepted)) {
            return false;
        }
        Date this$timeStarted = this.getTimeStarted();
        Date other$timeStarted = other.getTimeStarted();
        if (this$timeStarted == null ? other$timeStarted != null : !((Object)this$timeStarted).equals(other$timeStarted)) {
            return false;
        }
        Date this$timeFinished = this.getTimeFinished();
        Date other$timeFinished = other.getTimeFinished();
        if (this$timeFinished == null ? other$timeFinished != null : !((Object)this$timeFinished).equals(other$timeFinished)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $odaInstanceId = this.getOdaInstanceId();
        result = result * 59 + ($odaInstanceId == null ? 43 : $odaInstanceId.hashCode());
        RequestAction $requestAction = this.getRequestAction();
        result = result * 59 + ($requestAction == null ? 43 : ((Object)((Object)$requestAction)).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $statusMessage = this.getStatusMessage();
        result = result * 59 + ($statusMessage == null ? 43 : $statusMessage.hashCode());
        List<WorkRequestResource> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Float $percentComplete = this.getPercentComplete();
        result = result * 59 + ($percentComplete == null ? 43 : ((Object)$percentComplete).hashCode());
        Date $timeAccepted = this.getTimeAccepted();
        result = result * 59 + ($timeAccepted == null ? 43 : ((Object)$timeAccepted).hashCode());
        Date $timeStarted = this.getTimeStarted();
        result = result * 59 + ($timeStarted == null ? 43 : ((Object)$timeStarted).hashCode());
        Date $timeFinished = this.getTimeFinished();
        result = result * 59 + ($timeFinished == null ? 43 : ((Object)$timeFinished).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "WorkRequest(id=" + this.getId() + ", compartmentId=" + this.getCompartmentId() + ", odaInstanceId=" + this.getOdaInstanceId() + ", requestAction=" + (Object)((Object)this.getRequestAction()) + ", status=" + (Object)((Object)this.getStatus()) + ", statusMessage=" + this.getStatusMessage() + ", resources=" + this.getResources() + ", percentComplete=" + this.getPercentComplete() + ", timeAccepted=" + this.getTimeAccepted() + ", timeStarted=" + this.getTimeStarted() + ", timeFinished=" + this.getTimeFinished() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "compartmentId", "odaInstanceId", "requestAction", "status", "statusMessage", "resources", "percentComplete", "timeAccepted", "timeStarted", "timeFinished"})
    @Deprecated
    public WorkRequest(String id, String compartmentId, String odaInstanceId, RequestAction requestAction, Status status, String statusMessage, List<WorkRequestResource> resources, Float percentComplete, Date timeAccepted, Date timeStarted, Date timeFinished) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.odaInstanceId = odaInstanceId;
        this.requestAction = requestAction;
        this.status = status;
        this.statusMessage = statusMessage;
        this.resources = resources;
        this.percentComplete = percentComplete;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
    }

    public static enum Status {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Succeeded("SUCCEEDED"),
        Failed("FAILED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum RequestAction {
        CreateOdaInstance("CREATE_ODA_INSTANCE"),
        UpgradeOdaInstance("UPGRADE_ODA_INSTANCE"),
        DeleteOdaInstance("DELETE_ODA_INSTANCE"),
        PurgeOdaInstance("PURGE_ODA_INSTANCE"),
        RecoverOdaInstance("RECOVER_ODA_INSTANCE"),
        StopOdaInstance("STOP_ODA_INSTANCE"),
        StartOdaInstance("START_ODA_INSTANCE"),
        ChangeOdaInstanceCompartment("CHANGE_ODA_INSTANCE_COMPARTMENT"),
        CreateAssociation("CREATE_ASSOCIATION"),
        DeleteAssociation("DELETE_ASSOCIATION"),
        UpdateEntitlementsForCacct("UPDATE_ENTITLEMENTS_FOR_CACCT"),
        LookupOdaInstancesForCacct("LOOKUP_ODA_INSTANCES_FOR_CACCT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RequestAction> map;

        private RequestAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RequestAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RequestAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RequestAction.class);
            map = new HashMap<String, RequestAction>();
            for (RequestAction v : RequestAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="odaInstanceId")
        private String odaInstanceId;
        @JsonProperty(value="requestAction")
        private RequestAction requestAction;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="statusMessage")
        private String statusMessage;
        @JsonProperty(value="resources")
        private List<WorkRequestResource> resources;
        @JsonProperty(value="percentComplete")
        private Float percentComplete;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            this.__explicitlySet__.add("odaInstanceId");
            return this;
        }

        public Builder requestAction(RequestAction requestAction) {
            this.requestAction = requestAction;
            this.__explicitlySet__.add("requestAction");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            this.__explicitlySet__.add("statusMessage");
            return this;
        }

        public Builder resources(List<WorkRequestResource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder percentComplete(Float percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public WorkRequest build() {
            WorkRequest __instance__ = new WorkRequest(this.id, this.compartmentId, this.odaInstanceId, this.requestAction, this.status, this.statusMessage, this.resources, this.percentComplete, this.timeAccepted, this.timeStarted, this.timeFinished);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WorkRequest o) {
            Builder copiedBuilder = this.id(o.getId()).compartmentId(o.getCompartmentId()).odaInstanceId(o.getOdaInstanceId()).requestAction(o.getRequestAction()).status(o.getStatus()).statusMessage(o.getStatusMessage()).resources(o.getResources()).percentComplete(o.getPercentComplete()).timeAccepted(o.getTimeAccepted()).timeStarted(o.getTimeStarted()).timeFinished(o.getTimeFinished());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "WorkRequest.Builder(id=" + this.id + ", compartmentId=" + this.compartmentId + ", odaInstanceId=" + this.odaInstanceId + ", requestAction=" + (Object)((Object)this.requestAction) + ", status=" + (Object)((Object)this.status) + ", statusMessage=" + this.statusMessage + ", resources=" + this.resources + ", percentComplete=" + this.percentComplete + ", timeAccepted=" + this.timeAccepted + ", timeStarted=" + this.timeStarted + ", timeFinished=" + this.timeFinished + ")";
        }
    }
}

