/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRunLogRequest
extends BmcRequest<Void> {
    private String runId;
    private String name;
    private String opcRequestId;

    @ConstructorProperties(value={"runId", "name", "opcRequestId"})
    GetRunLogRequest(String runId, String name, String opcRequestId) {
        this.runId = runId;
        this.name = name;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRunId() {
        return this.runId;
    }

    public String getName() {
        return this.name;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRunLogRequest, Void> {
        private String runId;
        private String name;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRunLogRequest o) {
            this.runId(o.getRunId());
            this.name(o.getName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRunLogRequest build() {
            GetRunLogRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRunLogRequest buildWithoutInvocationCallback() {
            return new GetRunLogRequest(this.runId, this.name, this.opcRequestId);
        }

        public String toString() {
            return "GetRunLogRequest.Builder(runId=" + this.runId + ", name=" + this.name + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

