/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataflow.model.Run;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateRunConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateRunConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateRunRequest interceptRequest(UpdateRunRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateRunRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateRunDetails(), (String)"updateRunDetails is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200129").path("runs").path(HttpUtils.encodePathSegment((String)request.getRunId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateRunResponse> fromResponse() {
        Function<Response, UpdateRunResponse> transformer = new Function<Response, UpdateRunResponse>(){

            public UpdateRunResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dataflow.responses.UpdateRunResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Run.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateRunResponse.Builder builder = UpdateRunResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.run((Run)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                UpdateRunResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

