/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataflow.DataFlow;
import com.oracle.bmc.dataflow.DataFlowPaginators;
import com.oracle.bmc.dataflow.DataFlowWaiters;
import com.oracle.bmc.dataflow.internal.http.ChangeApplicationCompartmentConverter;
import com.oracle.bmc.dataflow.internal.http.ChangePrivateEndpointCompartmentConverter;
import com.oracle.bmc.dataflow.internal.http.ChangeRunCompartmentConverter;
import com.oracle.bmc.dataflow.internal.http.CreateApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.CreatePrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.CreateRunConverter;
import com.oracle.bmc.dataflow.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.DeletePrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.DeleteRunConverter;
import com.oracle.bmc.dataflow.internal.http.GetApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.GetPrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.GetRunConverter;
import com.oracle.bmc.dataflow.internal.http.GetRunLogConverter;
import com.oracle.bmc.dataflow.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.dataflow.internal.http.ListApplicationsConverter;
import com.oracle.bmc.dataflow.internal.http.ListPrivateEndpointsConverter;
import com.oracle.bmc.dataflow.internal.http.ListRunLogsConverter;
import com.oracle.bmc.dataflow.internal.http.ListRunsConverter;
import com.oracle.bmc.dataflow.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.dataflow.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.dataflow.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.dataflow.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.UpdatePrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.UpdateRunConverter;
import com.oracle.bmc.dataflow.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeRunCompartmentRequest;
import com.oracle.bmc.dataflow.requests.CreateApplicationRequest;
import com.oracle.bmc.dataflow.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateRunRequest;
import com.oracle.bmc.dataflow.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataflow.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteRunRequest;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataflow.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeRunCompartmentResponse;
import com.oracle.bmc.dataflow.responses.CreateApplicationResponse;
import com.oracle.bmc.dataflow.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateRunResponse;
import com.oracle.bmc.dataflow.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataflow.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteRunResponse;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataflow.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataflow.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlowClient
implements DataFlow {
    private static final Logger LOG = LoggerFactory.getLogger(DataFlowClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAFLOW").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataflow.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DataFlowWaiters waiters;
    private final DataFlowPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DataFlowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataFlowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataFlowClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DataFlowClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DataFlow-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataFlowWaiters(executorService, this);
        this.paginators = new DataFlowPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeApplicationCompartmentResponse changeApplicationCompartment(ChangeApplicationCompartmentRequest request) {
        LOG.trace("Called changeApplicationCompartment");
        ChangeApplicationCompartmentRequest interceptedRequest = ChangeApplicationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApplicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApplicationCompartmentResponse> transformer = ChangeApplicationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeApplicationCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeApplicationCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeApplicationCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeApplicationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangePrivateEndpointCompartmentResponse changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request) {
        LOG.trace("Called changePrivateEndpointCompartment");
        ChangePrivateEndpointCompartmentRequest interceptedRequest = ChangePrivateEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePrivateEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePrivateEndpointCompartmentResponse> transformer = ChangePrivateEndpointCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangePrivateEndpointCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangePrivateEndpointCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangePrivateEndpointCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangePrivateEndpointCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeRunCompartmentResponse changeRunCompartment(ChangeRunCompartmentRequest request) {
        LOG.trace("Called changeRunCompartment");
        ChangeRunCompartmentRequest interceptedRequest = ChangeRunCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRunCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRunCompartmentResponse> transformer = ChangeRunCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeRunCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeRunCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeRunCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeRunCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        LOG.trace("Called createApplication");
        CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateApplicationDetails(), (BmcRequest)retriedRequest);
                return (CreateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreatePrivateEndpointResponse createPrivateEndpoint(CreatePrivateEndpointRequest request) {
        LOG.trace("Called createPrivateEndpoint");
        CreatePrivateEndpointRequest interceptedRequest = CreatePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePrivateEndpointResponse> transformer = CreatePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreatePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreatePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreatePrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (CreatePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateRunResponse createRun(CreateRunRequest request) {
        LOG.trace("Called createRun");
        CreateRunRequest interceptedRequest = CreateRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRunResponse> transformer = CreateRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateRunDetails(), (BmcRequest)retriedRequest);
                return (CreateRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest request) {
        LOG.trace("Called deleteApplication");
        DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeletePrivateEndpointResponse deletePrivateEndpoint(DeletePrivateEndpointRequest request) {
        LOG.trace("Called deletePrivateEndpoint");
        DeletePrivateEndpointRequest interceptedRequest = DeletePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePrivateEndpointResponse> transformer = DeletePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeletePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeletePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeletePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteRunResponse deleteRun(DeleteRunRequest request) {
        LOG.trace("Called deleteRun");
        DeleteRunRequest interceptedRequest = DeleteRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRunResponse> transformer = DeleteRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetApplicationResponse getApplication(GetApplicationRequest request) {
        LOG.trace("Called getApplication");
        GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetPrivateEndpointResponse getPrivateEndpoint(GetPrivateEndpointRequest request) {
        LOG.trace("Called getPrivateEndpoint");
        GetPrivateEndpointRequest interceptedRequest = GetPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPrivateEndpointResponse> transformer = GetPrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetPrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetPrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetPrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRunResponse getRun(GetRunRequest request) {
        LOG.trace("Called getRun");
        GetRunRequest interceptedRequest = GetRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRunResponse> transformer = GetRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetRunLogResponse getRunLog(GetRunLogRequest request) {
        LOG.trace("Called getRunLog");
        GetRunLogRequest interceptedRequest = GetRunLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRunLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRunLogResponse> transformer = GetRunLogConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetRunLogResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetRunLogResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetRunLogResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest request) {
        LOG.trace("Called listApplications");
        ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListApplicationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListApplicationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListApplicationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListPrivateEndpointsResponse listPrivateEndpoints(ListPrivateEndpointsRequest request) {
        LOG.trace("Called listPrivateEndpoints");
        ListPrivateEndpointsRequest interceptedRequest = ListPrivateEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPrivateEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPrivateEndpointsResponse> transformer = ListPrivateEndpointsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListPrivateEndpointsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListPrivateEndpointsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListPrivateEndpointsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRunLogsResponse listRunLogs(ListRunLogsRequest request) {
        LOG.trace("Called listRunLogs");
        ListRunLogsRequest interceptedRequest = ListRunLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRunLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRunLogsResponse> transformer = ListRunLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRunLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRunLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRunLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListRunsResponse listRuns(ListRunsRequest request) {
        LOG.trace("Called listRuns");
        ListRunsRequest interceptedRequest = ListRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRunsResponse> transformer = ListRunsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListRunsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListRunsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListRunsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest request) {
        LOG.trace("Called updateApplication");
        UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateApplicationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateApplicationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateApplicationDetails(), (BmcRequest)retriedRequest);
                return (UpdateApplicationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdatePrivateEndpointResponse updatePrivateEndpoint(UpdatePrivateEndpointRequest request) {
        LOG.trace("Called updatePrivateEndpoint");
        UpdatePrivateEndpointRequest interceptedRequest = UpdatePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePrivateEndpointResponse> transformer = UpdatePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdatePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdatePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdatePrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (UpdatePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateRunResponse updateRun(UpdateRunRequest request) {
        LOG.trace("Called updateRun");
        UpdateRunRequest interceptedRequest = UpdateRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRunResponse> transformer = UpdateRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateRunDetails(), (BmcRequest)retriedRequest);
                return (UpdateRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DataFlowWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataFlowPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataFlowClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataFlowClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DataFlowClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

