/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dataflow.DataFlowAsync;
import com.oracle.bmc.dataflow.internal.http.ChangeApplicationCompartmentConverter;
import com.oracle.bmc.dataflow.internal.http.ChangePrivateEndpointCompartmentConverter;
import com.oracle.bmc.dataflow.internal.http.ChangeRunCompartmentConverter;
import com.oracle.bmc.dataflow.internal.http.CreateApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.CreatePrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.CreateRunConverter;
import com.oracle.bmc.dataflow.internal.http.DeleteApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.DeletePrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.DeleteRunConverter;
import com.oracle.bmc.dataflow.internal.http.GetApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.GetPrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.GetRunConverter;
import com.oracle.bmc.dataflow.internal.http.GetRunLogConverter;
import com.oracle.bmc.dataflow.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.dataflow.internal.http.ListApplicationsConverter;
import com.oracle.bmc.dataflow.internal.http.ListPrivateEndpointsConverter;
import com.oracle.bmc.dataflow.internal.http.ListRunLogsConverter;
import com.oracle.bmc.dataflow.internal.http.ListRunsConverter;
import com.oracle.bmc.dataflow.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.dataflow.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.dataflow.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.dataflow.internal.http.UpdateApplicationConverter;
import com.oracle.bmc.dataflow.internal.http.UpdatePrivateEndpointConverter;
import com.oracle.bmc.dataflow.internal.http.UpdateRunConverter;
import com.oracle.bmc.dataflow.requests.ChangeApplicationCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangePrivateEndpointCompartmentRequest;
import com.oracle.bmc.dataflow.requests.ChangeRunCompartmentRequest;
import com.oracle.bmc.dataflow.requests.CreateApplicationRequest;
import com.oracle.bmc.dataflow.requests.CreatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.CreateRunRequest;
import com.oracle.bmc.dataflow.requests.DeleteApplicationRequest;
import com.oracle.bmc.dataflow.requests.DeletePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.DeleteRunRequest;
import com.oracle.bmc.dataflow.requests.GetApplicationRequest;
import com.oracle.bmc.dataflow.requests.GetPrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.requests.GetRunRequest;
import com.oracle.bmc.dataflow.requests.GetWorkRequestRequest;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.requests.UpdateApplicationRequest;
import com.oracle.bmc.dataflow.requests.UpdatePrivateEndpointRequest;
import com.oracle.bmc.dataflow.requests.UpdateRunRequest;
import com.oracle.bmc.dataflow.responses.ChangeApplicationCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangePrivateEndpointCompartmentResponse;
import com.oracle.bmc.dataflow.responses.ChangeRunCompartmentResponse;
import com.oracle.bmc.dataflow.responses.CreateApplicationResponse;
import com.oracle.bmc.dataflow.responses.CreatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.CreateRunResponse;
import com.oracle.bmc.dataflow.responses.DeleteApplicationResponse;
import com.oracle.bmc.dataflow.responses.DeletePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.DeleteRunResponse;
import com.oracle.bmc.dataflow.responses.GetApplicationResponse;
import com.oracle.bmc.dataflow.responses.GetPrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.dataflow.responses.GetRunResponse;
import com.oracle.bmc.dataflow.responses.GetWorkRequestResponse;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.dataflow.responses.UpdateApplicationResponse;
import com.oracle.bmc.dataflow.responses.UpdatePrivateEndpointResponse;
import com.oracle.bmc.dataflow.responses.UpdateRunResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataFlowAsyncClient
implements DataFlowAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DataFlowAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATAFLOW").serviceEndpointPrefix("").serviceEndpointTemplate("https://dataflow.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DataFlowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataFlowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataFlowAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DataFlowAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeApplicationCompartmentResponse> changeApplicationCompartment(ChangeApplicationCompartmentRequest request, AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handler) {
        LOG.trace("Called async changeApplicationCompartment");
        ChangeApplicationCompartmentRequest interceptedRequest = ChangeApplicationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeApplicationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeApplicationCompartmentResponse> transformer = ChangeApplicationCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeApplicationCompartmentRequest, ChangeApplicationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangePrivateEndpointCompartmentResponse> changePrivateEndpointCompartment(ChangePrivateEndpointCompartmentRequest request, AsyncHandler<ChangePrivateEndpointCompartmentRequest, ChangePrivateEndpointCompartmentResponse> handler) {
        LOG.trace("Called async changePrivateEndpointCompartment");
        ChangePrivateEndpointCompartmentRequest interceptedRequest = ChangePrivateEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangePrivateEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangePrivateEndpointCompartmentResponse> transformer = ChangePrivateEndpointCompartmentConverter.fromResponse();
        AsyncHandler<ChangePrivateEndpointCompartmentRequest, ChangePrivateEndpointCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangePrivateEndpointCompartmentRequest, ChangePrivateEndpointCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeRunCompartmentResponse> changeRunCompartment(ChangeRunCompartmentRequest request, AsyncHandler<ChangeRunCompartmentRequest, ChangeRunCompartmentResponse> handler) {
        LOG.trace("Called async changeRunCompartment");
        ChangeRunCompartmentRequest interceptedRequest = ChangeRunCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeRunCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeRunCompartmentResponse> transformer = ChangeRunCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeRunCompartmentRequest, ChangeRunCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeRunCompartmentRequest, ChangeRunCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateApplicationResponse> createApplication(CreateApplicationRequest request, AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handler) {
        LOG.trace("Called async createApplication");
        CreateApplicationRequest interceptedRequest = CreateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateApplicationResponse> transformer = CreateApplicationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateApplicationRequest, CreateApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateApplicationRequest, CreateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreatePrivateEndpointResponse> createPrivateEndpoint(CreatePrivateEndpointRequest request, AsyncHandler<CreatePrivateEndpointRequest, CreatePrivateEndpointResponse> handler) {
        LOG.trace("Called async createPrivateEndpoint");
        CreatePrivateEndpointRequest interceptedRequest = CreatePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreatePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreatePrivateEndpointResponse> transformer = CreatePrivateEndpointConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreatePrivateEndpointRequest, CreatePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreatePrivateEndpointRequest, CreatePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateRunResponse> createRun(CreateRunRequest request, AsyncHandler<CreateRunRequest, CreateRunResponse> handler) {
        LOG.trace("Called async createRun");
        CreateRunRequest interceptedRequest = CreateRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateRunResponse> transformer = CreateRunConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateRunRequest, CreateRunResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateRunRequest, CreateRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest request, AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handler) {
        LOG.trace("Called async deleteApplication");
        DeleteApplicationRequest interceptedRequest = DeleteApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteApplicationResponse> transformer = DeleteApplicationConverter.fromResponse();
        AsyncHandler<DeleteApplicationRequest, DeleteApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteApplicationRequest, DeleteApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeletePrivateEndpointResponse> deletePrivateEndpoint(DeletePrivateEndpointRequest request, AsyncHandler<DeletePrivateEndpointRequest, DeletePrivateEndpointResponse> handler) {
        LOG.trace("Called async deletePrivateEndpoint");
        DeletePrivateEndpointRequest interceptedRequest = DeletePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeletePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeletePrivateEndpointResponse> transformer = DeletePrivateEndpointConverter.fromResponse();
        AsyncHandler<DeletePrivateEndpointRequest, DeletePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeletePrivateEndpointRequest, DeletePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteRunResponse> deleteRun(DeleteRunRequest request, AsyncHandler<DeleteRunRequest, DeleteRunResponse> handler) {
        LOG.trace("Called async deleteRun");
        DeleteRunRequest interceptedRequest = DeleteRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteRunResponse> transformer = DeleteRunConverter.fromResponse();
        AsyncHandler<DeleteRunRequest, DeleteRunResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteRunRequest, DeleteRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetApplicationResponse> getApplication(GetApplicationRequest request, AsyncHandler<GetApplicationRequest, GetApplicationResponse> handler) {
        LOG.trace("Called async getApplication");
        GetApplicationRequest interceptedRequest = GetApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetApplicationResponse> transformer = GetApplicationConverter.fromResponse();
        AsyncHandler<GetApplicationRequest, GetApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetApplicationRequest, GetApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetPrivateEndpointResponse> getPrivateEndpoint(GetPrivateEndpointRequest request, AsyncHandler<GetPrivateEndpointRequest, GetPrivateEndpointResponse> handler) {
        LOG.trace("Called async getPrivateEndpoint");
        GetPrivateEndpointRequest interceptedRequest = GetPrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetPrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetPrivateEndpointResponse> transformer = GetPrivateEndpointConverter.fromResponse();
        AsyncHandler<GetPrivateEndpointRequest, GetPrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetPrivateEndpointRequest, GetPrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRunResponse> getRun(GetRunRequest request, AsyncHandler<GetRunRequest, GetRunResponse> handler) {
        LOG.trace("Called async getRun");
        GetRunRequest interceptedRequest = GetRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRunResponse> transformer = GetRunConverter.fromResponse();
        AsyncHandler<GetRunRequest, GetRunResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRunRequest, GetRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetRunLogResponse> getRunLog(GetRunLogRequest request, AsyncHandler<GetRunLogRequest, GetRunLogResponse> handler) {
        LOG.trace("Called async getRunLog");
        GetRunLogRequest interceptedRequest = GetRunLogConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetRunLogConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetRunLogResponse> transformer = GetRunLogConverter.fromResponse();
        AsyncHandler<GetRunLogRequest, GetRunLogResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetRunLogRequest, GetRunLogResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListApplicationsResponse> listApplications(ListApplicationsRequest request, AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handler) {
        LOG.trace("Called async listApplications");
        ListApplicationsRequest interceptedRequest = ListApplicationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListApplicationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListApplicationsResponse> transformer = ListApplicationsConverter.fromResponse();
        AsyncHandler<ListApplicationsRequest, ListApplicationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListApplicationsRequest, ListApplicationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListPrivateEndpointsResponse> listPrivateEndpoints(ListPrivateEndpointsRequest request, AsyncHandler<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse> handler) {
        LOG.trace("Called async listPrivateEndpoints");
        ListPrivateEndpointsRequest interceptedRequest = ListPrivateEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListPrivateEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListPrivateEndpointsResponse> transformer = ListPrivateEndpointsConverter.fromResponse();
        AsyncHandler<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRunLogsResponse> listRunLogs(ListRunLogsRequest request, AsyncHandler<ListRunLogsRequest, ListRunLogsResponse> handler) {
        LOG.trace("Called async listRunLogs");
        ListRunLogsRequest interceptedRequest = ListRunLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRunLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRunLogsResponse> transformer = ListRunLogsConverter.fromResponse();
        AsyncHandler<ListRunLogsRequest, ListRunLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRunLogsRequest, ListRunLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListRunsResponse> listRuns(ListRunsRequest request, AsyncHandler<ListRunsRequest, ListRunsResponse> handler) {
        LOG.trace("Called async listRuns");
        ListRunsRequest interceptedRequest = ListRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListRunsResponse> transformer = ListRunsConverter.fromResponse();
        AsyncHandler<ListRunsRequest, ListRunsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListRunsRequest, ListRunsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest request, AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handler) {
        LOG.trace("Called async updateApplication");
        UpdateApplicationRequest interceptedRequest = UpdateApplicationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateApplicationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateApplicationResponse> transformer = UpdateApplicationConverter.fromResponse();
        AsyncHandler<UpdateApplicationRequest, UpdateApplicationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateApplicationRequest, UpdateApplicationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdatePrivateEndpointResponse> updatePrivateEndpoint(UpdatePrivateEndpointRequest request, AsyncHandler<UpdatePrivateEndpointRequest, UpdatePrivateEndpointResponse> handler) {
        LOG.trace("Called async updatePrivateEndpoint");
        UpdatePrivateEndpointRequest interceptedRequest = UpdatePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdatePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdatePrivateEndpointResponse> transformer = UpdatePrivateEndpointConverter.fromResponse();
        AsyncHandler<UpdatePrivateEndpointRequest, UpdatePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdatePrivateEndpointRequest, UpdatePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateRunResponse> updateRun(UpdateRunRequest request, AsyncHandler<UpdateRunRequest, UpdateRunResponse> handler) {
        LOG.trace("Called async updateRun");
        UpdateRunRequest interceptedRequest = UpdateRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateRunResponse> transformer = UpdateRunConverter.fromResponse();
        AsyncHandler<UpdateRunRequest, UpdateRunResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateRunRequest, UpdateRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataFlowAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataFlowAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DataFlowAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

