/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.GenericWaiter;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.WaiterConfiguration;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BmcGenericWaiter {
    private static final Logger LOG = LoggerFactory.getLogger(BmcGenericWaiter.class);
    private final GenericWaiter waiter;

    public BmcGenericWaiter(TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        WaiterConfiguration waiterConfig = new WaiterConfiguration(terminationStrategy, delayStrategy);
        this.waiter = new GenericWaiter(waiterConfig);
    }

    public <REQUEST, RESPONSE> RESPONSE execute(Supplier<REQUEST> requestSupplier, Function<REQUEST, RESPONSE> functionCall, Predicate<RESPONSE> terminationPredicate, boolean allow404) throws WaitConditionFailedException {
        LOG.debug("Invoking waiter with 404 allowed set to {}", (Object)allow404);
        try {
            Optional<RESPONSE> response = this.waiter.execute(requestSupplier, functionCall, terminationPredicate);
            if (response.isPresent()) {
                return (RESPONSE)response.get();
            }
        }
        catch (BmcException e) {
            if (e.getStatusCode() == 404) {
                if (allow404) {
                    LOG.debug("Allowing 404 response");
                    return null;
                }
                LOG.debug("Received 404, waiter configured not to allow it");
            }
            throw e;
        }
        throw new WaitConditionFailedException("Failed to reach desired condition");
    }

    public <REQUEST, RESPONSE> Callable<RESPONSE> toCallable(final Supplier<REQUEST> requestSupplier, final Function<REQUEST, RESPONSE> functionCall, final Predicate<RESPONSE> terminationPredicate, final boolean allow404) {
        return new Callable<RESPONSE>(){

            @Override
            public RESPONSE call() throws Exception {
                return BmcGenericWaiter.this.execute(requestSupplier, functionCall, terminationPredicate, allow404);
            }
        };
    }

    public static final class WaitConditionFailedException
    extends Exception {
        private WaitConditionFailedException(String message) {
            super(message);
        }
    }
}

