/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetStatusRequest
extends BmcRequest<Void> {
    private String source;
    private String ocid;
    private String opcRequestId;
    private String homeregion;

    @ConstructorProperties(value={"source", "ocid", "opcRequestId", "homeregion"})
    GetStatusRequest(String source, String ocid, String opcRequestId, String homeregion) {
        this.source = source;
        this.ocid = ocid;
        this.opcRequestId = opcRequestId;
        this.homeregion = homeregion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getSource() {
        return this.source;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStatusRequest, Void> {
        private String source;
        private String ocid;
        private String opcRequestId;
        private String homeregion;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStatusRequest o) {
            this.source(o.getSource());
            this.ocid(o.getOcid());
            this.opcRequestId(o.getOpcRequestId());
            this.homeregion(o.getHomeregion());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStatusRequest build() {
            GetStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public GetStatusRequest buildWithoutInvocationCallback() {
            return new GetStatusRequest(this.source, this.ocid, this.opcRequestId, this.homeregion);
        }

        public String toString() {
            return "GetStatusRequest.Builder(source=" + this.source + ", ocid=" + this.ocid + ", opcRequestId=" + this.opcRequestId + ", homeregion=" + this.homeregion + ")";
        }
    }
}

