/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.OffsetDST;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class TIMESTAMPLTZ
extends Datum {
    static final Calendar CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
    private static int SIZE_TIMESTAMPLTZ = 11;
    private static int SIZE_TIMESTAMPLTZ_NOFRAC = 7;
    private static int SIZE_DATE = 7;
    private static int ONE_HOUR = 3600000;
    private static int ONE_MINUTE = 60000;
    private static int JAVA_YEAR = 1970;
    private static int JAVA_MONTH = 0;
    private static int JAVA_DATE = 1;
    private static int MINYEAR = -4712;
    private static int MAXYEAR = 9999;
    private static int SECOND_MILLISECOND = 1000;
    private static boolean cached = false;
    private static Calendar dbtz;
    static final long serialVersionUID = 2045880772054757133L;

    public TIMESTAMPLTZ() {
        super(TIMESTAMPLTZ.initTimestampltz());
    }

    public TIMESTAMPLTZ(byte[] byArray) {
        super(byArray);
    }

    public TIMESTAMPLTZ(Connection connection, Time time, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, time, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Date date, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, date, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, timestamp, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, DATE dATE, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, dATE, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, String string, Calendar calendar) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, string, calendar));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, time));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, date));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, timestamp));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, DATE dATE) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, dATE));
    }

    public TIMESTAMPLTZ(Connection connection, Calendar calendar, String string) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, calendar, string));
    }

    public TIMESTAMPLTZ(Connection connection, Time time) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), time));
    }

    public TIMESTAMPLTZ(Connection connection, Date date) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), date));
    }

    public TIMESTAMPLTZ(Connection connection, Timestamp timestamp) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), timestamp));
    }

    public TIMESTAMPLTZ(Connection connection, DATE dATE) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), dATE));
    }

    public TIMESTAMPLTZ(Connection connection, String string) throws SQLException {
        super(TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.getSessCalendar(connection), TIMESTAMPLTZ.parseTimestampLtz(connection, string)));
    }

    public static Date toDate(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Calendar calendar2 = TIMESTAMPLTZ.toCalendar(connection, Calendar.getInstance(), byArray, calendar);
        long l2 = calendar2.getTime().getTime();
        return new Date(l2);
    }

    public static Time toTime(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Calendar calendar2 = TIMESTAMPLTZ.toCalendar(connection, Calendar.getInstance(), byArray, calendar);
        calendar2.set(1, 1970);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        return new Time(calendar2.getTime().getTime());
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, Calendar.getInstance(), byArray, calendar);
    }

    public static DATE toDATE(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        return new DATE(TIMESTAMPLTZ.toTimestamp(connection, TIMESTAMPLTZ.getSessCalendar(connection), byArray, null));
    }

    public Timestamp timestampValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, this.getBytes(), calendar);
    }

    public Timestamp timestampValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, this.getBytes());
    }

    @DisableTrace
    public static String toString(Connection connection, byte[] byArray, Calendar calendar) throws SQLException {
        Calendar calendar2 = TIMESTAMPLTZ.toCalendar(connection, null, byArray, calendar);
        int n2 = calendar2.get(1);
        if (calendar2.get(0) == 0) {
            n2 = -(n2 - 1);
        }
        int n3 = calendar2.get(2) + 1;
        int n4 = calendar2.get(5);
        int n5 = calendar2.get(11);
        int n6 = calendar2.get(12);
        int n7 = calendar2.get(13);
        int n8 = -1;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n8 = TIMESTAMP.getNanos(byArray, 7);
        }
        return TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, n8, calendar2.getTimeZone().getID());
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Connection connection, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
        calendar2.set(1, n2);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Date date, Calendar calendar) throws SQLException {
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        if (OracleDriver.getSystemPropertyDateZeroTime()) {
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
        }
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        int n2 = timestamp.getNanos();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, n2);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, DATE dATE, Calendar calendar) throws SQLException {
        if (dATE == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(DATE.toDate(dATE.toBytes()));
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, String string, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, TIMESTAMPLTZ.parseTimestampLtz(connection, string), calendar);
    }

    public static Date toDate(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        long l2 = calendar.getTime().getTime();
        return new Date(l2);
    }

    public static LocalDateTime toLocalDateTime(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -(n2 - 1);
        }
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n8 = TIMESTAMP.getNanos(byArray, 7);
        }
        return LocalDateTime.of(n2, n3, n4, n5, n6, n7, n8);
    }

    public static OffsetDateTime toOffsetDateTime(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -(n2 - 1);
        }
        int n3 = calendar.get(2) + 1;
        int n4 = calendar.get(5);
        int n5 = calendar.get(11);
        int n6 = calendar.get(12);
        int n7 = calendar.get(13);
        int n8 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n8 = TIMESTAMP.getNanos(byArray, 7);
        }
        Calendar calendar2 = TIMESTAMPLTZ.getSessCalendar(connection);
        int n9 = calendar2.get(15);
        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n9 / SECOND_MILLISECOND);
        return OffsetDateTime.of(n2, n3, n4, n5, n6, n7, n8, zoneOffset);
    }

    public static Time toTime(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return new Time(calendar.getTime().getTime());
    }

    public static Timestamp toTimestamp(Connection connection, byte[] byArray) throws SQLException {
        return TIMESTAMPLTZ.toTimestamp(connection, null, byArray, null);
    }

    public static DATE toDATE(Connection connection, byte[] byArray) throws SQLException {
        Calendar calendar = TIMESTAMPLTZ.toCalendar(connection, null, byArray, null);
        long l2 = calendar.getTime().getTime();
        return new DATE(new Timestamp(l2));
    }

    public static TIMESTAMP toTIMESTAMP(Connection connection, byte[] byArray) throws SQLException {
        return new TIMESTAMP(TIMESTAMPLTZ.toTimestamp(connection, TIMESTAMPLTZ.getSessCalendar(connection), byArray, null));
    }

    public static TIMESTAMPTZ toTIMESTAMPTZ(Connection connection, byte[] byArray) throws SQLException {
        return new TIMESTAMPTZ(connection, TIMESTAMPLTZ.toTimestamp(connection, TIMESTAMPLTZ.getSessCalendar(connection), byArray, null), TIMESTAMPLTZ.getSessCalendar(connection));
    }

    @DisableTrace
    public static String toString(Connection connection, byte[] byArray) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, byArray, null);
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Time time) throws SQLException {
        if (time == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? TIMESTAMPLTZ.getSessCalendar(connection) : (Calendar)calendar.clone();
        calendar2.setTime(time);
        int n2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getUse1900AsYearForTime() ? 1900 : 1970;
        calendar2.set(1, n2);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar3 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar3, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Date date) throws SQLException {
        if (date == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? TIMESTAMPLTZ.getSessCalendar(connection) : (Calendar)calendar.clone();
        calendar2.setTime(date);
        if (OracleDriver.getSystemPropertyDateZeroTime()) {
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
        }
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar3 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar3, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? TIMESTAMPLTZ.getSessCalendar(connection) : (Calendar)calendar.clone();
        calendar2.setTime(timestamp);
        int n2 = timestamp.getNanos();
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar3 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar3, n2);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, DATE dATE) throws SQLException {
        if (dATE == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? TIMESTAMPLTZ.getSessCalendar(connection) : (Calendar)calendar.clone();
        calendar2.setTime(DATE.toDate(dATE.toBytes()));
        TIMESTAMPLTZ.initDbTimeZone(connection);
        Calendar calendar3 = (Calendar)dbtz.clone();
        byte[] byArray = TIMESTAMPLTZ.toBytes(connection, calendar2, calendar3, 0);
        return byArray;
    }

    public static byte[] toBytes(Connection connection, Calendar calendar, String string) throws SQLException {
        return TIMESTAMPLTZ.toBytes(connection, calendar, TIMESTAMPLTZ.parseTimestampLtz(connection, string));
    }

    @Override
    @DisableTrace
    public String stringValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes());
    }

    @DisableTrace
    public String stringValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toString(connection, this.getBytes(), calendar);
    }

    public Date dateValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes(), calendar);
    }

    public Date dateValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toDate(connection, this.getBytes());
    }

    public LocalDateTime localDateTimeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toLocalDateTime(connection, this.getBytes());
    }

    public OffsetDateTime offsetDateTimeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toOffsetDateTime(connection, this.getBytes());
    }

    public Time timeValue(Connection connection) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes());
    }

    public Time timeValue(Connection connection, Calendar calendar) throws SQLException {
        return TIMESTAMPLTZ.toTime(connection, this.getBytes(), calendar);
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this;
    }

    @Override
    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public static void TimeZoneAdjust(Connection connection, Calendar calendar, Calendar calendar2) throws SQLException {
        calendar2.setTimeInMillis(calendar.getTimeInMillis());
    }

    public static long TimeZoneAdjustUTC(Connection connection, Calendar calendar) throws SQLException {
        return calendar.getTimeInMillis();
    }

    private static byte[] initTimestampltz() {
        byte[] byArray = new byte[SIZE_TIMESTAMPLTZ];
        byArray[0] = 119;
        byArray[1] = -86;
        byArray[2] = 1;
        byArray[3] = 1;
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return byArray;
    }

    private static byte[] toBytes(Connection connection, Calendar calendar, Calendar calendar2, int n2) throws SQLException {
        byte[] byArray = n2 == 0 ? new byte[SIZE_TIMESTAMPLTZ_NOFRAC] : new byte[SIZE_TIMESTAMPLTZ];
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar, calendar2);
        int n3 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n3 / 100 + 100);
        byArray[1] = (byte)(n3 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        if (n2 != 0) {
            byArray[7] = (byte)(n2 >> 24);
            byArray[8] = (byte)(n2 >> 16 & 0xFF);
            byArray[9] = (byte)(n2 >> 8 & 0xFF);
            byArray[10] = (byte)(n2 & 0xFF);
        }
        return byArray;
    }

    private static Timestamp toTimestamp(Connection connection, Calendar calendar, byte[] byArray, Calendar calendar2) throws SQLException {
        Calendar calendar3 = TIMESTAMPLTZ.toCalendar(connection, calendar, byArray, calendar2);
        long l2 = calendar3.getTime().getTime();
        Timestamp timestamp = new Timestamp(l2);
        int n2 = 0;
        if (byArray.length == SIZE_TIMESTAMPLTZ) {
            n2 = TIMESTAMP.getNanos(byArray, 7);
        }
        timestamp.setNanos(n2);
        return timestamp;
    }

    private static final Calendar toCalendar(Connection connection, Calendar calendar, byte[] byArray, Calendar calendar2) throws SQLException {
        int n2;
        int n3 = byArray.length;
        int[] nArray = n3 == SIZE_TIMESTAMPLTZ ? new int[SIZE_TIMESTAMPLTZ] : new int[SIZE_TIMESTAMPLTZ_NOFRAC];
        for (n2 = 0; n2 < byArray.length; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        if (calendar2 == null) {
            TIMESTAMPLTZ.initDbTimeZone(connection);
            calendar2 = (Calendar)dbtz.clone();
        }
        calendar2.set(1, n2);
        calendar2.set(2, nArray[2] - 1);
        calendar2.set(5, nArray[3]);
        calendar2.set(11, nArray[4] - 1);
        calendar2.set(12, nArray[5] - 1);
        calendar2.set(13, nArray[6] - 1);
        int n4 = 0;
        if (n3 == SIZE_TIMESTAMPLTZ) {
            n4 = TIMESTAMP.getNanos(byArray, 7) / 1000000;
        }
        calendar2.set(14, n4);
        Calendar calendar3 = calendar == null ? TIMESTAMPLTZ.getSessCalendar(connection) : (Calendar)calendar.clone();
        TIMESTAMPLTZ.TimeZoneAdjust(connection, calendar2, calendar3);
        return calendar3;
    }

    private static byte getZoneOffset(Connection connection, Calendar calendar, OffsetDST offsetDST) throws SQLException {
        byte by = 0;
        String string = calendar.getTimeZone().getID();
        if (string == "Custom" || string.startsWith("GMT") && string.length() > 3) {
            offsetDST.setOFFSET(calendar.getTimeZone().getRawOffset());
        } else {
            int n2 = ZONEIDMAP.getID(string);
            if (!ZONEIDMAP.isValidID(n2)) {
                throw (SQLException)DatabaseError.createSqlException(199).fillInStackTrace();
            }
            TIMEZONETAB tIMEZONETAB = TIMESTAMPLTZ.getTIMEZONETAB(connection);
            if (tIMEZONETAB.checkID(n2)) {
                tIMEZONETAB.updateTable(connection, n2);
            }
            by = tIMEZONETAB.getLocalOffset(calendar, n2, offsetDST);
        }
        return by;
    }

    private static Calendar getDbTzCalendar(String string) {
        char c2 = string.charAt(0);
        String string2 = c2 == '+' || c2 == '-' ? "GMT" + string : string;
        TimeZone timeZone = TimeZone.getTimeZone(string2);
        return new GregorianCalendar(timeZone);
    }

    private static Timestamp parseTimestampLtz(Connection connection, String string) throws SQLException {
        if (string == null) {
            throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
        }
        try {
            Timestamp timestamp = Timestamp.valueOf(string);
            return timestamp;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Object object;
            Object object2;
            int n2;
            String string2;
            String string3;
            String string4 = string.trim();
            int n3 = string4.indexOf(32);
            if (n3 == -1) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            String string5 = string4.substring(0, n3).trim();
            if (string5 == null | (string3 = string4.substring(n3 + 1).trim()) == null) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            boolean bl = false;
            if (string5.charAt(0) == '-') {
                bl = true;
                if (string5.length() > 1) {
                    string5 = string5.substring(1);
                } else {
                    throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                }
            }
            int n4 = string5.indexOf(45);
            int n5 = string5.indexOf(45, n4 + 1);
            if (n4 < 1 || n5 < 1 || n5 == string5.length()) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            String string6 = string5.substring(0, n4);
            String string7 = string5.substring(n4 + 1, n5);
            String string8 = string5.substring(n5 + 1);
            if (string6.length() != 4 || string7.length() != 2 || string8.length() != 2) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            int n6 = Integer.parseInt(string6);
            int n7 = Integer.parseInt(string7) - 1;
            int n8 = Integer.parseInt(string8);
            if (bl) {
                n6 = -n6;
            }
            int n9 = string3.indexOf(58);
            int n10 = string3.indexOf(58, n9 + 1);
            n3 = string3.indexOf(32);
            if (n3 != -1) {
                string2 = string3.substring(n3 + 1).trim();
                string3 = string3.substring(0, n3).trim();
            } else {
                string2 = null;
            }
            if (n9 < 1 || n10 < 1 || n10 == string3.length()) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            String string9 = string3.substring(0, n9);
            String string10 = string3.substring(n9 + 1, n10);
            if (string9.length() != 2 || string10.length() != 2) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            int n11 = Integer.parseInt(string9);
            int n12 = Integer.parseInt(string10);
            int n13 = 0;
            int n14 = string3.indexOf(46, n10 + 1);
            if (n14 == -1) {
                n2 = Integer.parseInt(string3.substring(n10 + 1));
            } else if (n14 > 0 && n14 < string3.length() - 1) {
                n2 = Integer.parseInt(string3.substring(n10 + 1, n14));
                object2 = string3.substring(n14 + 1);
                object = "000000000";
                if (((String)object2).length() > ((String)object).length() || !Character.isDigit(((String)object2).charAt(0))) {
                    throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                }
                object2 = (String)object2 + ((String)object).substring(0, ((String)object).length() - ((String)object2).length());
                n13 = Integer.parseInt((String)object2);
            } else {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            object2 = null;
            if (string2 != null) {
                char c2 = string2.charAt(0);
                if (c2 == '-') {
                    string2 = "GMT" + string2;
                } else if (Character.isDigit(c2)) {
                    string2 = "GMT+" + string2;
                }
                object2 = Calendar.getInstance(TimeZone.getTimeZone(string2));
            }
            object = object2 == null ? TIMESTAMPLTZ.getSessCalendar(connection) : object2;
            ((Calendar)object).set(1, n6);
            ((Calendar)object).set(2, n7);
            ((Calendar)object).set(5, n8);
            ((Calendar)object).set(11, n11);
            ((Calendar)object).set(12, n12);
            ((Calendar)object).set(13, n2);
            ((Calendar)object).set(14, 0);
            Timestamp timestamp = new Timestamp(((Calendar)object).getTime().getTime());
            timestamp.setNanos(n13);
            return timestamp;
        }
    }

    static Calendar getSessCalendar(Connection connection) {
        Calendar calendar;
        String string = ((oracle.jdbc.OracleConnection)connection).getSessionTimeZone();
        if (string == null) {
            calendar = Calendar.getInstance();
        } else {
            TimeZone timeZone = TimeZone.getTimeZone(string);
            calendar = Calendar.getInstance(timeZone);
        }
        return calendar;
    }

    private static synchronized void initDbTimeZone(Connection connection) throws SQLException {
        if (!cached) {
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            String string = oracleConnection.getDatabaseTimeZone();
            dbtz = TIMESTAMPLTZ.getDbTzCalendar(string);
            cached = true;
        }
    }

    static TIMEZONETAB getTIMEZONETAB(Connection connection) throws SQLException {
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        return oracleConnection.getTIMEZONETAB();
    }
}

