/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.util.Arrays;
import java.util.List;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.driver.cli.AbstractCommand;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.Option;

class ShowConfigurationCommand
extends AbstractCommand {
    ShowConfigurationCommand() {
    }

    @Override
    public String getName() {
        return "show-config";
    }

    @Override
    public String getShortUsage() {
        return "Show the driver configuration";
    }

    @Override
    public String getLongUsage() {
        return "  Prints the JDBC configuration.";
    }

    @Override
    public List<Option> getExpectedOptions() {
        Option help = new Option("help", "h", "Show help message", false, 1);
        return Arrays.asList(help);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.hasOption("help")) {
            this.printCommandHelp(context.getCommandPrefix());
            return;
        }
        try {
            OracleDriver.printConfiguration();
        }
        catch (Exception e) {
            System.out.println("Error while processing: " + e.getMessage());
        }
    }
}

