/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

class NodeAddress {
    public final String hostname;
    public final int port;
    public final int key;

    NodeAddress(String s) {
        int i = s.lastIndexOf(":");
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        this.hostname = s.substring(0, i);
        this.port = Integer.parseInt(s.substring(i + 1));
        this.key = 0;
    }

    NodeAddress(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.key = 0;
    }

    NodeAddress(String hostname, int port, int key) {
        this.hostname = hostname;
        this.port = port;
        this.key = key;
    }

    NodeAddress(NodeAddress parent, int key) {
        this.hostname = parent.hostname;
        this.port = parent.port;
        this.key = key;
    }

    public int hashCode() {
        return this.hostname.hashCode() + this.port * 179425171 + this.key * 8429;
    }

    public boolean equals(Object obj) {
        NodeAddress other = obj instanceof NodeAddress ? (NodeAddress)obj : null;
        return other == this || other != null && this.hostname.equals(other.hostname) && this.port == other.port && this.key == other.key;
    }

    public String toString() {
        return String.format("%s:%d", this.hostname, this.port);
    }
}

