/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swaption;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.measure.swaption.SwaptionMarketDataLookup;
import com.opengamma.strata.measure.swaption.SwaptionMeasureCalculations;
import com.opengamma.strata.measure.swaption.SwaptionScenarioMarketData;
import com.opengamma.strata.product.swaption.ResolvedSwaptionTrade;
import com.opengamma.strata.product.swaption.Swaption;
import com.opengamma.strata.product.swaption.SwaptionTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SwaptionTradeCalculationFunction
implements CalculationFunction<SwaptionTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, SwaptionMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, SwaptionMeasureCalculations.DEFAULT::pv01RatesCalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, SwaptionMeasureCalculations.DEFAULT::pv01RatesCalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, SwaptionMeasureCalculations.DEFAULT::pv01RatesMarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, SwaptionMeasureCalculations.DEFAULT::pv01RatesMarketQuoteBucketed).put((Object)Measures.VEGA_MARKET_QUOTE_BUCKETED, SwaptionMeasureCalculations.DEFAULT::vegaMarketQuoteBucketed).put((Object)Measures.CURRENCY_EXPOSURE, SwaptionMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, SwaptionMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd, m) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<SwaptionTrade> targetType() {
        return SwaptionTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(SwaptionTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(SwaptionTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrency();
    }

    public FunctionRequirements requirements(SwaptionTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        Swaption product = trade.getProduct();
        Currency currency = product.getCurrency();
        RateIndex index = product.getIndex();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements(currency, new Index[]{index});
        SwaptionMarketDataLookup swaptionLookup = (SwaptionMarketDataLookup)parameters.getParameter(SwaptionMarketDataLookup.class);
        FunctionRequirements swaptionReqs = swaptionLookup.requirements(index);
        return ratesReqs.combinedWith(swaptionReqs);
    }

    public Map<Measure, Result<?>> calculate(SwaptionTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedSwaptionTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        SwaptionMarketDataLookup swaptionLookup = (SwaptionMarketDataLookup)parameters.getParameter(SwaptionMarketDataLookup.class);
        SwaptionScenarioMarketData swaptionMarketData = swaptionLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ratesMarketData, swaptionMarketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for SwaptionTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, ratesMarketData, swaptionMarketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedSwaptionTrade var1, RatesScenarioMarketData var2, SwaptionScenarioMarketData var3);
    }
}

