/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swaption;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.swaption.DefaultSwaptionMarketData;
import com.opengamma.strata.measure.swaption.DefaultSwaptionMarketDataLookup;
import com.opengamma.strata.measure.swaption.DefaultSwaptionScenarioMarketData;
import com.opengamma.strata.measure.swaption.SwaptionMarketData;
import com.opengamma.strata.measure.swaption.SwaptionScenarioMarketData;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilitiesId;
import java.util.Map;
import java.util.Set;

public interface SwaptionMarketDataLookup
extends CalculationParameter {
    public static SwaptionMarketDataLookup of(RateIndex index, SwaptionVolatilitiesId volatilityId) {
        return DefaultSwaptionMarketDataLookup.of((Map<RateIndex, SwaptionVolatilitiesId>)ImmutableMap.of((Object)index, (Object)volatilityId));
    }

    public static SwaptionMarketDataLookup of(Map<RateIndex, SwaptionVolatilitiesId> volatilityIds) {
        return DefaultSwaptionMarketDataLookup.of(volatilityIds);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return SwaptionMarketDataLookup.class;
    }

    public ImmutableSet<RateIndex> getVolatilityIndices();

    public ImmutableSet<MarketDataId<?>> getVolatilityIds(RateIndex var1);

    default public FunctionRequirements requirements(RateIndex ... indices) {
        return this.requirements((Set<RateIndex>)ImmutableSet.copyOf((Object[])indices));
    }

    public FunctionRequirements requirements(Set<RateIndex> var1);

    default public SwaptionScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultSwaptionScenarioMarketData.of(this, marketData);
    }

    default public SwaptionMarketData marketDataView(MarketData marketData) {
        return DefaultSwaptionMarketData.of(this, marketData);
    }

    public SwaptionVolatilities volatilities(RateIndex var1, MarketData var2);
}

