/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swaption;

import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.measure.swaption.SwaptionMarketData;
import com.opengamma.strata.measure.swaption.SwaptionMarketDataLookup;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultSwaptionMarketData
implements SwaptionMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SwaptionMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketData marketData;
    private static final TypedMetaBean<DefaultSwaptionMarketData> META_BEAN = LightMetaBean.of(DefaultSwaptionMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultSwaptionMarketData of(SwaptionMarketDataLookup lookup, MarketData marketData) {
        return new DefaultSwaptionMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultSwaptionMarketData(SwaptionMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (SwaptionMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    @Override
    public SwaptionMarketData withMarketData(MarketData marketData) {
        return DefaultSwaptionMarketData.of(this.lookup, marketData);
    }

    @Override
    public SwaptionVolatilities volatilities(RateIndex index) {
        return this.lookup.volatilities(index, this.marketData);
    }

    public static TypedMetaBean<DefaultSwaptionMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultSwaptionMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public SwaptionMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultSwaptionMarketData other = (DefaultSwaptionMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultSwaptionMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

