/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.security;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.product.Security;

final class SecurityMeasureCalculations {
    private SecurityMeasureCalculations() {
    }

    static CurrencyScenarioArray presentValue(Security security, double quantity, ScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> SecurityMeasureCalculations.calculatePresentValue(security, quantity, marketData.scenario(i)));
    }

    private static CurrencyAmount calculatePresentValue(Security security, double quantity, MarketData marketData) {
        QuoteId id = QuoteId.of((StandardId)security.getSecurityId().getStandardId());
        double price = (Double)marketData.getValue((MarketDataId)id);
        return security.getInfo().getPriceInfo().calculateMonetaryAmount(quantity, price);
    }
}

