/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesMarketData;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultRatesScenarioMarketData
implements RatesScenarioMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final RatesMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ScenarioMarketData marketData;
    private final transient AtomicReferenceArray<RatesMarketData> cache;
    private static final TypedMetaBean<DefaultRatesScenarioMarketData> META_BEAN = LightMetaBean.of(DefaultRatesScenarioMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultRatesScenarioMarketData of(RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return new DefaultRatesScenarioMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultRatesScenarioMarketData(RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        this.lookup = (RatesMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (ScenarioMarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.cache = new AtomicReferenceArray(marketData.getScenarioCount());
    }

    private Object readResolve() {
        return new DefaultRatesScenarioMarketData(this.lookup, this.marketData);
    }

    @Override
    public RatesScenarioMarketData withMarketData(ScenarioMarketData marketData) {
        return DefaultRatesScenarioMarketData.of(this.lookup, marketData);
    }

    @Override
    public int getScenarioCount() {
        return this.marketData.getScenarioCount();
    }

    @Override
    public RatesMarketData scenario(int scenarioIndex) {
        RatesMarketData current = this.cache.get(scenarioIndex);
        if (current != null) {
            return current;
        }
        return this.cache.updateAndGet(scenarioIndex, v -> v != null ? v : this.lookup.marketDataView(this.marketData.scenario(scenarioIndex)));
    }

    public static TypedMetaBean<DefaultRatesScenarioMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultRatesScenarioMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public RatesMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public ScenarioMarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultRatesScenarioMarketData other = (DefaultRatesScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultRatesScenarioMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

