/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.rate;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.observable.IndexQuoteId;
import com.opengamma.strata.measure.rate.DefaultRatesMarketDataLookup;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.fx.DiscountFxForwardRates;
import com.opengamma.strata.pricer.fx.ForwardFxIndexRates;
import com.opengamma.strata.pricer.fx.FxForwardRates;
import com.opengamma.strata.pricer.fx.FxIndexRates;
import com.opengamma.strata.pricer.rate.HistoricIborIndexRates;
import com.opengamma.strata.pricer.rate.HistoricOvernightIndexRates;
import com.opengamma.strata.pricer.rate.HistoricPriceIndexValues;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.pricer.rate.OvernightIndexRates;
import com.opengamma.strata.pricer.rate.PriceIndexValues;
import com.opengamma.strata.pricer.rate.RatesProvider;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultLookupRatesProvider
implements RatesProvider,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DefaultRatesMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull")
    private final MarketData marketData;
    private final transient FxRateProvider fxRateProvider;
    private static final TypedMetaBean<DefaultLookupRatesProvider> META_BEAN = LightMetaBean.of(DefaultLookupRatesProvider.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultLookupRatesProvider of(DefaultRatesMarketDataLookup lookup, MarketData marketData) {
        return new DefaultLookupRatesProvider(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultLookupRatesProvider(DefaultRatesMarketDataLookup lookup, MarketData marketData) {
        this.lookup = (DefaultRatesMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (MarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.fxRateProvider = lookup.fxRateProvider(marketData);
    }

    private Object readResolve() {
        return new DefaultLookupRatesProvider(this.lookup, this.marketData);
    }

    public LocalDate getValuationDate() {
        return this.marketData.getValuationDate();
    }

    public ImmutableSet<Currency> getDiscountCurrencies() {
        return this.lookup.getDiscountCurrencies();
    }

    public Stream<Index> indices() {
        return this.lookup.getForwardIndices().stream();
    }

    public ImmutableSet<IborIndex> getIborIndices() {
        return (ImmutableSet)this.lookup.getForwardIndices().stream().flatMap(Guavate.filtering(IborIndex.class)).collect(Guavate.toImmutableSet());
    }

    public ImmutableSet<OvernightIndex> getOvernightIndices() {
        return (ImmutableSet)this.lookup.getForwardIndices().stream().flatMap(Guavate.filtering(OvernightIndex.class)).collect(Guavate.toImmutableSet());
    }

    public ImmutableSet<PriceIndex> getPriceIndices() {
        return (ImmutableSet)this.lookup.getForwardIndices().stream().flatMap(Guavate.filtering(PriceIndex.class)).collect(Guavate.toImmutableSet());
    }

    public ImmutableSet<Index> getTimeSeriesIndices() {
        return (ImmutableSet)this.marketData.getTimeSeriesIds().stream().flatMap(Guavate.filtering(IndexQuoteId.class)).map(id -> id.getIndex()).collect(Guavate.toImmutableSet());
    }

    public <T> T data(MarketDataId<T> key) {
        return (T)this.marketData.getValue(key);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        return Stream.concat(this.lookup.getDiscountCurves().values().stream(), this.lookup.getForwardCurves().values().stream()).filter(id -> id.getMarketDataName().equals((Object)name)).findFirst().flatMap(id -> this.marketData.findValue((MarketDataId)id)).map(v -> name.getMarketDataType().cast(v));
    }

    public LocalDateDoubleTimeSeries timeSeries(Index index) {
        return this.marketData.getTimeSeries((ObservableId)IndexQuoteId.of((Index)index));
    }

    public double fxRate(Currency baseCurrency, Currency counterCurrency) {
        return this.fxRateProvider.fxRate(baseCurrency, counterCurrency);
    }

    public DiscountFactors discountFactors(Currency currency) {
        CurveId curveId = (CurveId)this.lookup.getDiscountCurves().get((Object)currency);
        if (curveId == null) {
            throw new MarketDataNotFoundException(this.lookup.msgCurrencyNotFound(currency));
        }
        Curve curve = (Curve)this.marketData.getValue((MarketDataId)curveId);
        return DiscountFactors.of((Currency)currency, (LocalDate)this.getValuationDate(), (Curve)curve);
    }

    public FxIndexRates fxIndexRates(FxIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        FxForwardRates fxForwardRates = this.fxForwardRates(index.getCurrencyPair());
        return ForwardFxIndexRates.of((FxIndex)index, (FxForwardRates)fxForwardRates, (LocalDateDoubleTimeSeries)fixings);
    }

    public FxForwardRates fxForwardRates(CurrencyPair currencyPair) {
        DiscountFactors base = this.discountFactors(currencyPair.getBase());
        DiscountFactors counter = this.discountFactors(currencyPair.getCounter());
        FxRate fxRate = FxRate.of((CurrencyPair)currencyPair, (double)this.fxRate(currencyPair));
        return DiscountFxForwardRates.of((CurrencyPair)currencyPair, (FxRateProvider)fxRate, (DiscountFactors)base, (DiscountFactors)counter);
    }

    public IborIndexRates iborIndexRates(IborIndex index) {
        CurveId curveId = (CurveId)this.lookup.getForwardCurves().get((Object)index);
        if (curveId == null) {
            return this.historicCurve(index);
        }
        return IborIndexRates.of((IborIndex)index, (LocalDate)this.getValuationDate(), (Curve)((Curve)this.marketData.getValue((MarketDataId)curveId)), (LocalDateDoubleTimeSeries)this.timeSeries((Index)index));
    }

    private IborIndexRates historicCurve(IborIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        if (index.isActive() || fixings.isEmpty()) {
            throw new MarketDataNotFoundException(this.lookup.msgIndexNotFound((Index)index));
        }
        return HistoricIborIndexRates.of((IborIndex)index, (LocalDate)this.getValuationDate(), (LocalDateDoubleTimeSeries)fixings);
    }

    public OvernightIndexRates overnightIndexRates(OvernightIndex index) {
        CurveId curveId = (CurveId)this.lookup.getForwardCurves().get((Object)index);
        if (curveId == null) {
            return this.historicCurve(index);
        }
        return OvernightIndexRates.of((OvernightIndex)index, (LocalDate)this.getValuationDate(), (Curve)((Curve)this.marketData.getValue((MarketDataId)curveId)), (LocalDateDoubleTimeSeries)this.timeSeries((Index)index));
    }

    private OvernightIndexRates historicCurve(OvernightIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        if (index.isActive() || fixings.isEmpty()) {
            throw new MarketDataNotFoundException(this.lookup.msgIndexNotFound((Index)index));
        }
        return HistoricOvernightIndexRates.of((OvernightIndex)index, (LocalDate)this.getValuationDate(), (LocalDateDoubleTimeSeries)fixings);
    }

    public PriceIndexValues priceIndexValues(PriceIndex index) {
        CurveId curveId = (CurveId)this.lookup.getForwardCurves().get((Object)index);
        if (curveId == null) {
            return this.historicCurve(index);
        }
        return PriceIndexValues.of((PriceIndex)index, (LocalDate)this.getValuationDate(), (Curve)((Curve)this.marketData.getValue((MarketDataId)curveId)), (LocalDateDoubleTimeSeries)this.timeSeries((Index)index));
    }

    private PriceIndexValues historicCurve(PriceIndex index) {
        LocalDateDoubleTimeSeries fixings = this.timeSeries((Index)index);
        if (index.isActive() || fixings.isEmpty()) {
            throw new MarketDataNotFoundException(this.lookup.msgIndexNotFound((Index)index));
        }
        return HistoricPriceIndexValues.of((PriceIndex)index, (LocalDate)this.getValuationDate(), (LocalDateDoubleTimeSeries)fixings);
    }

    public ImmutableRatesProvider toImmutableRatesProvider() {
        HashMap<Currency, Object> dscMap = new HashMap<Currency, Object>();
        for (Currency currency : this.lookup.getDiscountCurrencies()) {
            CurveId curveId = (CurveId)this.lookup.getDiscountCurves().get((Object)currency);
            if (curveId == null || !this.marketData.containsValue((MarketDataId)curveId)) continue;
            dscMap.put(currency, this.marketData.getValue((MarketDataId)curveId));
        }
        HashMap<Index, Object> fwdMap = new HashMap<Index, Object>();
        for (Index index : this.lookup.getForwardIndices()) {
            CurveId curveId = (CurveId)this.lookup.getForwardCurves().get((Object)index);
            if (curveId == null || !this.marketData.containsValue((MarketDataId)curveId)) continue;
            fwdMap.put(index, this.marketData.getValue((MarketDataId)curveId));
        }
        HashMap<Index, LocalDateDoubleTimeSeries> tsMap = new HashMap<Index, LocalDateDoubleTimeSeries>();
        for (ObservableId id : this.marketData.getTimeSeriesIds()) {
            if (!(id instanceof IndexQuoteId)) continue;
            IndexQuoteId indexId = (IndexQuoteId)id;
            tsMap.put(indexId.getIndex(), this.marketData.getTimeSeries(id));
        }
        return ImmutableRatesProvider.builder((LocalDate)this.getValuationDate()).discountCurves(dscMap).indexCurves(fwdMap).timeSeries(tsMap).fxRateProvider(this.fxRateProvider).build();
    }

    public static TypedMetaBean<DefaultLookupRatesProvider> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultLookupRatesProvider> metaBean() {
        return META_BEAN;
    }

    public DefaultRatesMarketDataLookup getLookup() {
        return this.lookup;
    }

    public MarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultLookupRatesProvider other = (DefaultLookupRatesProvider)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultLookupRatesProvider{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

