/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.payment;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.param.CrossGammaParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.BaseProvider;
import com.opengamma.strata.pricer.payment.DiscountingBulletPaymentTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.CurveGammaCalculator;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.payment.ResolvedBulletPaymentTrade;

final class BulletPaymentMeasureCalculations {
    public static final BulletPaymentMeasureCalculations DEFAULT = new BulletPaymentMeasureCalculations(DiscountingBulletPaymentTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final CurveGammaCalculator CROSS_GAMMA = CurveGammaCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingBulletPaymentTradePricer tradePricer;

    BulletPaymentMeasureCalculations(DiscountingBulletPaymentTradePricer tradePricer) {
        this.tradePricer = (DiscountingBulletPaymentTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyAmount presentValue(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.presentValue(trade, (BaseProvider)ratesProvider);
    }

    ScenarioArray<ExplainMap> explainPresentValue(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.explainPresentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    ExplainMap explainPresentValue(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.explainPresentValue(trade, (BaseProvider)ratesProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, (BaseProvider)ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, (BaseProvider)ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, (BaseProvider)ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, (BaseProvider)ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01SingleNodeGammaBucketed(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01SingleNodeGammaBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    private CurrencyParameterSensitivities pv01SingleNodeGammaBucketed(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        CrossGammaParameterSensitivities crossGamma = CROSS_GAMMA.calculateCrossGammaIntraCurve(ratesProvider, p -> p.parameterSensitivity(this.tradePricer.presentValueSensitivity(trade, (BaseProvider)p)));
        return crossGamma.diagonal().multipliedBy(1.0E-8);
    }

    ScenarioArray<CashFlows> cashFlows(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.cashFlows(trade, marketData.scenario(i).ratesProvider()));
    }

    CashFlows cashFlows(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.cashFlows(trade, (BaseProvider)ratesProvider);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{this.tradePricer.currencyExposure(trade, (BaseProvider)ratesProvider)});
    }

    CurrencyScenarioArray currentCash(ResolvedBulletPaymentTrade trade, RatesScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyAmount currentCash(ResolvedBulletPaymentTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currentCash(trade, (BaseProvider)ratesProvider);
    }
}

