/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.index.OvernightFutureMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.index.DiscountingOvernightFutureTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;

public class OvernightFutureTradeCalculations {
    public static final OvernightFutureTradeCalculations DEFAULT = new OvernightFutureTradeCalculations(DiscountingOvernightFutureTradePricer.DEFAULT);
    private final OvernightFutureMeasureCalculations calc;

    public OvernightFutureTradeCalculations(DiscountingOvernightFutureTradePricer tradePricer) {
        this.calc = new OvernightFutureMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.parSpread(trade, ratesProvider);
    }

    public DoubleScenarioArray unitPrice(ResolvedOvernightFutureTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.unitPrice(trade, lookup.marketDataView(marketData));
    }

    public double unitPrice(ResolvedOvernightFutureTrade trade, RatesProvider ratesProvider) {
        return this.calc.unitPrice(trade, ratesProvider);
    }
}

