/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.index.OvernightFutureMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.SecuritizedProductPortfolioItem;
import com.opengamma.strata.product.index.OvernightFuture;
import com.opengamma.strata.product.index.OvernightFuturePosition;
import com.opengamma.strata.product.index.OvernightFutureTrade;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OvernightFutureTradeCalculationFunction<T extends SecuritizedProductPortfolioItem<OvernightFuture> & Resolvable<ResolvedOvernightFutureTrade>>
implements CalculationFunction<T> {
    public static final OvernightFutureTradeCalculationFunction<OvernightFutureTrade> TRADE = new OvernightFutureTradeCalculationFunction<OvernightFutureTrade>(OvernightFutureTrade.class);
    public static final OvernightFutureTradeCalculationFunction<OvernightFuturePosition> POSITION = new OvernightFutureTradeCalculationFunction<OvernightFuturePosition>(OvernightFuturePosition.class);
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, OvernightFutureMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, OvernightFutureMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, OvernightFutureMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, OvernightFutureMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, OvernightFutureMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.UNIT_PRICE, OvernightFutureMeasureCalculations.DEFAULT::unitPrice).put((Object)Measures.PAR_SPREAD, OvernightFutureMeasureCalculations.DEFAULT::parSpread).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();
    private final Class<T> targetType;

    public OvernightFutureTradeCalculationFunction(Class<T> targetType) {
        this.targetType = (Class)ArgChecker.notNull(targetType, (String)"targetType");
    }

    public Class<T> targetType() {
        return this.targetType;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(T target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(T target, ReferenceData refData) {
        return ((OvernightFuture)target.getProduct()).getCurrency();
    }

    public FunctionRequirements requirements(T target, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        OvernightFuture product = (OvernightFuture)target.getProduct();
        QuoteId quoteId = QuoteId.of((StandardId)((OvernightFuture)target.getProduct()).getSecurityId().getStandardId(), (FieldName)FieldName.SETTLEMENT_PRICE);
        OvernightIndex index = product.getIndex();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements((Set<Currency>)ImmutableSet.of(), (Set<? extends Index>)ImmutableSet.of((Object)index));
        ImmutableSet valueReqs = ImmutableSet.builder().add((Object)quoteId).addAll((Iterable)ratesReqs.getValueRequirements()).build();
        return ratesReqs.toBuilder().valueRequirements((Set)valueReqs).build();
    }

    public Map<Measure, Result<?>> calculate(T target, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedOvernightFutureTrade resolved = (ResolvedOvernightFutureTrade)((Resolvable)target).resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData marketData = ratesLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedOvernightFutureTrade resolved, RatesScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for OvernightFutureTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(resolved, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedOvernightFutureTrade var1, RatesScenarioMarketData var2);
    }
}

