/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.index.IborFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.index.IborFutureOptionMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.NormalIborFutureOptionMarginedTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.index.ResolvedIborFutureOptionTrade;

public class IborFutureOptionTradeCalculations {
    public static final IborFutureOptionTradeCalculations DEFAULT = new IborFutureOptionTradeCalculations(NormalIborFutureOptionMarginedTradePricer.DEFAULT);
    private final IborFutureOptionMeasureCalculations calc;

    public IborFutureOptionTradeCalculations(NormalIborFutureOptionMarginedTradePricer tradePricer) {
        this.calc = new IborFutureOptionMeasureCalculations(tradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedIborFutureOptionTrade trade, RatesMarketDataLookup ratesLookup, IborFutureOptionMarketDataLookup optionLookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), optionLookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        return this.calc.presentValue(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedIborFutureOptionTrade trade, RatesMarketDataLookup ratesLookup, IborFutureOptionMarketDataLookup optionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, ratesLookup.marketDataView(marketData), optionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedIborFutureOptionTrade trade, RatesMarketDataLookup ratesLookup, IborFutureOptionMarketDataLookup optionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, ratesLookup.marketDataView(marketData), optionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedIborFutureOptionTrade trade, RatesMarketDataLookup ratesLookup, IborFutureOptionMarketDataLookup optionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, ratesLookup.marketDataView(marketData), optionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedIborFutureOptionTrade trade, RatesMarketDataLookup ratesLookup, IborFutureOptionMarketDataLookup optionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), optionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider, volatilities);
    }

    public DoubleScenarioArray unitPrice(ResolvedIborFutureOptionTrade trade, RatesMarketDataLookup ratesLookup, IborFutureOptionMarketDataLookup optionLookup, ScenarioMarketData marketData) {
        return this.calc.unitPrice(trade, ratesLookup.marketDataView(marketData), optionLookup.marketDataView(marketData));
    }

    public double unitPrice(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        return this.calc.unitPrice(trade, ratesProvider, volatilities);
    }
}

