/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.index.IborFutureOptionScenarioMarketData;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.NormalIborFutureOptionMarginedTradePricer;
import com.opengamma.strata.pricer.index.NormalIborFutureOptionVolatilities;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.index.ResolvedIborFutureOptionTrade;

final class IborFutureOptionMeasureCalculations {
    public static final IborFutureOptionMeasureCalculations DEFAULT = new IborFutureOptionMeasureCalculations(NormalIborFutureOptionMarginedTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final NormalIborFutureOptionMarginedTradePricer tradePricer;

    IborFutureOptionMeasureCalculations(NormalIborFutureOptionMarginedTradePricer tradePricer) {
        this.tradePricer = (NormalIborFutureOptionMarginedTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedIborFutureOptionTrade trade, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        IborIndex index = trade.getProduct().getUnderlyingFuture().getIndex();
        return CurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyAmount presentValue(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        double settlementPrice = this.settlementPrice(trade, ratesProvider);
        NormalIborFutureOptionVolatilities normalVols = this.checkNormalVols(volatilities);
        return this.tradePricer.presentValue(trade, ratesProvider, normalVols, settlementPrice);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedIborFutureOptionTrade trade, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        IborIndex index = trade.getProduct().getUnderlyingFuture().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        NormalIborFutureOptionVolatilities normalVols = this.checkNormalVols(volatilities);
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivityRates(trade, ratesProvider, normalVols);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedIborFutureOptionTrade trade, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        IborIndex index = trade.getProduct().getUnderlyingFuture().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        NormalIborFutureOptionVolatilities normalVols = this.checkNormalVols(volatilities);
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivityRates(trade, ratesProvider, normalVols);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedIborFutureOptionTrade trade, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        IborIndex index = trade.getProduct().getUnderlyingFuture().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        NormalIborFutureOptionVolatilities normalVols = this.checkNormalVols(volatilities);
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivityRates(trade, ratesProvider, normalVols);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedIborFutureOptionTrade trade, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        IborIndex index = trade.getProduct().getUnderlyingFuture().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        NormalIborFutureOptionVolatilities normalVols = this.checkNormalVols(volatilities);
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivityRates(trade, ratesProvider, normalVols);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    DoubleScenarioArray unitPrice(ResolvedIborFutureOptionTrade trade, RatesScenarioMarketData ratesMarketData, IborFutureOptionScenarioMarketData optionMarketData) {
        IborIndex index = trade.getProduct().getUnderlyingFuture().getIndex();
        return DoubleScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.unitPrice(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(index)));
    }

    double unitPrice(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider, IborFutureOptionVolatilities volatilities) {
        NormalIborFutureOptionVolatilities normalVols = this.checkNormalVols(volatilities);
        return this.tradePricer.price(trade, ratesProvider, normalVols);
    }

    private double settlementPrice(ResolvedIborFutureOptionTrade trade, RatesProvider ratesProvider) {
        StandardId standardId = trade.getProduct().getSecurityId().getStandardId();
        QuoteId id = QuoteId.of((StandardId)standardId, (FieldName)FieldName.SETTLEMENT_PRICE);
        return (Double)ratesProvider.data((MarketDataId)id);
    }

    private NormalIborFutureOptionVolatilities checkNormalVols(IborFutureOptionVolatilities volatilities) {
        if (volatilities instanceof NormalIborFutureOptionVolatilities) {
            return (NormalIborFutureOptionVolatilities)volatilities;
        }
        throw new IllegalArgumentException(Messages.format((String)"Ibor future option only supports Normal volatilities, but was '{}'", (Object)volatilities.getVolatilityType()));
    }
}

