/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.calc.runner.CalculationParameter;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.index.DefaultIborFutureOptionMarketData;
import com.opengamma.strata.measure.index.DefaultIborFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.index.DefaultIborFutureOptionScenarioMarketData;
import com.opengamma.strata.measure.index.IborFutureOptionMarketData;
import com.opengamma.strata.measure.index.IborFutureOptionScenarioMarketData;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilitiesId;
import java.util.Map;
import java.util.Set;

public interface IborFutureOptionMarketDataLookup
extends CalculationParameter {
    public static IborFutureOptionMarketDataLookup of(IborIndex index, IborFutureOptionVolatilitiesId volatilityId) {
        return DefaultIborFutureOptionMarketDataLookup.of((Map<IborIndex, IborFutureOptionVolatilitiesId>)ImmutableMap.of((Object)index, (Object)volatilityId));
    }

    public static IborFutureOptionMarketDataLookup of(Map<IborIndex, IborFutureOptionVolatilitiesId> volatilityIds) {
        return DefaultIborFutureOptionMarketDataLookup.of(volatilityIds);
    }

    default public Class<? extends CalculationParameter> queryType() {
        return IborFutureOptionMarketDataLookup.class;
    }

    public ImmutableSet<IborIndex> getVolatilityIndices();

    public ImmutableSet<MarketDataId<?>> getVolatilityIds(IborIndex var1);

    default public FunctionRequirements requirements(IborIndex ... indices) {
        return this.requirements((Set<IborIndex>)ImmutableSet.copyOf((Object[])indices));
    }

    public FunctionRequirements requirements(Set<IborIndex> var1);

    default public IborFutureOptionScenarioMarketData marketDataView(ScenarioMarketData marketData) {
        return DefaultIborFutureOptionScenarioMarketData.of(this, marketData);
    }

    default public IborFutureOptionMarketData marketDataView(MarketData marketData) {
        return DefaultIborFutureOptionMarketData.of(this, marketData);
    }

    public IborFutureOptionVolatilities volatilities(IborIndex var1, MarketData var2);
}

