/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.FieldName;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.index.DiscountingIborFutureTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.index.ResolvedIborFutureTrade;

final class IborFutureMeasureCalculations {
    public static final IborFutureMeasureCalculations DEFAULT = new IborFutureMeasureCalculations(DiscountingIborFutureTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final DiscountingIborFutureTradePricer tradePricer;

    IborFutureMeasureCalculations(DiscountingIborFutureTradePricer tradePricer) {
        this.tradePricer = (DiscountingIborFutureTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return CurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyAmount presentValue(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        double settlementPrice = this.settlementPrice(trade, ratesProvider);
        return this.tradePricer.presentValue(trade, ratesProvider, settlementPrice);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    DoubleScenarioArray parSpread(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parSpread(trade, marketData.scenario(i).ratesProvider()));
    }

    double parSpread(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        double settlementPrice = this.settlementPrice(trade, ratesProvider);
        return this.tradePricer.parSpread(trade, ratesProvider, settlementPrice);
    }

    DoubleScenarioArray unitPrice(ResolvedIborFutureTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.unitPrice(trade, marketData.scenario(i).ratesProvider()));
    }

    double unitPrice(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.price(trade, ratesProvider);
    }

    private double settlementPrice(ResolvedIborFutureTrade trade, RatesProvider ratesProvider) {
        StandardId standardId = trade.getProduct().getSecurityId().getStandardId();
        QuoteId id = QuoteId.of((StandardId)standardId, (FieldName)FieldName.SETTLEMENT_PRICE);
        return (Double)ratesProvider.data((MarketDataId)id) / 100.0;
    }
}

