/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.index.IborFutureOptionMarketData;
import com.opengamma.strata.measure.index.IborFutureOptionMarketDataLookup;
import com.opengamma.strata.measure.index.IborFutureOptionScenarioMarketData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultIborFutureOptionScenarioMarketData
implements IborFutureOptionScenarioMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborFutureOptionMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ScenarioMarketData marketData;
    private static final TypedMetaBean<DefaultIborFutureOptionScenarioMarketData> META_BEAN = LightMetaBean.of(DefaultIborFutureOptionScenarioMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultIborFutureOptionScenarioMarketData of(IborFutureOptionMarketDataLookup lookup, ScenarioMarketData marketData) {
        return new DefaultIborFutureOptionScenarioMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultIborFutureOptionScenarioMarketData(IborFutureOptionMarketDataLookup lookup, ScenarioMarketData marketData) {
        this.lookup = (IborFutureOptionMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (ScenarioMarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
    }

    @Override
    public IborFutureOptionScenarioMarketData withMarketData(ScenarioMarketData marketData) {
        return DefaultIborFutureOptionScenarioMarketData.of(this.lookup, marketData);
    }

    @Override
    public int getScenarioCount() {
        return this.marketData.getScenarioCount();
    }

    @Override
    public IborFutureOptionMarketData scenario(int scenarioIndex) {
        return this.lookup.marketDataView(this.marketData.scenario(scenarioIndex));
    }

    public static TypedMetaBean<DefaultIborFutureOptionScenarioMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultIborFutureOptionScenarioMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public IborFutureOptionMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public ScenarioMarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultIborFutureOptionScenarioMarketData other = (DefaultIborFutureOptionScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultIborFutureOptionScenarioMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

