/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.measure.index.IborFutureOptionMarketDataLookup;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilities;
import com.opengamma.strata.pricer.index.IborFutureOptionVolatilitiesId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultIborFutureOptionMarketDataLookup
implements IborFutureOptionMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<IborIndex, IborFutureOptionVolatilitiesId> volatilityIds;
    private static final TypedMetaBean<DefaultIborFutureOptionMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultIborFutureOptionMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"volatilityIds"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static DefaultIborFutureOptionMarketDataLookup of(IborIndex index, IborFutureOptionVolatilitiesId volatilityId) {
        return new DefaultIborFutureOptionMarketDataLookup((Map<IborIndex, IborFutureOptionVolatilitiesId>)ImmutableMap.of((Object)index, (Object)volatilityId));
    }

    public static DefaultIborFutureOptionMarketDataLookup of(Map<IborIndex, IborFutureOptionVolatilitiesId> volatilityIds) {
        return new DefaultIborFutureOptionMarketDataLookup(volatilityIds);
    }

    @Override
    public ImmutableSet<IborIndex> getVolatilityIndices() {
        return this.volatilityIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getVolatilityIds(IborIndex index) {
        IborFutureOptionVolatilitiesId id = (IborFutureOptionVolatilitiesId)this.volatilityIds.get((Object)index);
        if (id == null) {
            throw new IllegalArgumentException(this.msgIndexNotFound((Index)index));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(Set<IborIndex> indices) {
        HashSet<Object> volIds = new HashSet<Object>();
        for (Index index : indices) {
            if (!this.volatilityIds.keySet().contains((Object)index)) {
                throw new IllegalArgumentException(this.msgIndexNotFound(index));
            }
            volIds.add(this.volatilityIds.get((Object)index));
        }
        return FunctionRequirements.builder().valueRequirements(volIds).build();
    }

    @Override
    public IborFutureOptionVolatilities volatilities(IborIndex index, MarketData marketData) {
        IborFutureOptionVolatilitiesId volatilityId = (IborFutureOptionVolatilitiesId)this.volatilityIds.get((Object)index);
        if (volatilityId == null) {
            throw new MarketDataNotFoundException(this.msgIndexNotFound((Index)index));
        }
        return (IborFutureOptionVolatilities)marketData.getValue((MarketDataId)volatilityId);
    }

    private String msgIndexNotFound(Index index) {
        return Messages.format((String)"IborFutureOption lookup has no volatilities defined for index '{}'", (Object)index);
    }

    public static TypedMetaBean<DefaultIborFutureOptionMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultIborFutureOptionMarketDataLookup(Map<IborIndex, IborFutureOptionVolatilitiesId> volatilityIds) {
        JodaBeanUtils.notNull(volatilityIds, (String)"volatilityIds");
        this.volatilityIds = ImmutableMap.copyOf(volatilityIds);
    }

    public TypedMetaBean<DefaultIborFutureOptionMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<IborIndex, IborFutureOptionVolatilitiesId> getVolatilityIds() {
        return this.volatilityIds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultIborFutureOptionMarketDataLookup other = (DefaultIborFutureOptionMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.volatilityIds, other.volatilityIds);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.volatilityIds);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultIborFutureOptionMarketDataLookup{");
        buf.append("volatilityIds").append('=').append(JodaBeanUtils.toString(this.volatilityIds));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

