/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.measure.fxopt.FxVanillaOptionMeasureCalculations;
import com.opengamma.strata.measure.fxopt.FxVanillaOptionMethod;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.fxopt.BlackFxVanillaOptionTradePricer;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.VannaVolgaFxVanillaOptionTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOptionTrade;

public class FxVanillaOptionTradeCalculations {
    public static final FxVanillaOptionTradeCalculations DEFAULT = new FxVanillaOptionTradeCalculations(BlackFxVanillaOptionTradePricer.DEFAULT, VannaVolgaFxVanillaOptionTradePricer.DEFAULT);
    private final FxVanillaOptionMeasureCalculations calc;

    public FxVanillaOptionTradeCalculations(BlackFxVanillaOptionTradePricer blackPricer, VannaVolgaFxVanillaOptionTradePricer vannaVolgaPricer) {
        this.calc = new FxVanillaOptionMeasureCalculations(blackPricer, vannaVolgaPricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount presentValue(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.presentValue(trade, ratesProvider, volatilities, method);
    }

    public MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesProvider, volatilities, method);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesProvider, volatilities, method);
    }

    public MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesProvider, volatilities, method);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesProvider, volatilities, method);
    }

    public ScenarioArray<CurrencyParameterSensitivities> vegaMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.vegaMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyParameterSensitivities vegaMarketQuoteBucketed(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.vegaMarketQuoteBucketed(trade, ratesProvider, volatilities, method);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.currencyExposure(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.currencyExposure(trade, ratesProvider, volatilities, method);
    }

    public CurrencyScenarioArray currentCash(ResolvedFxVanillaOptionTrade trade, RatesMarketDataLookup ratesLookup, FxOptionMarketDataLookup fxLookup, ScenarioMarketData marketData, FxVanillaOptionMethod method) {
        return this.calc.currentCash(trade, ratesLookup.marketDataView(marketData), fxLookup.marketDataView(marketData), method);
    }

    public CurrencyAmount currentCash(ResolvedFxVanillaOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxVanillaOptionMethod method) {
        return this.calc.currentCash(trade, ratesProvider.getValuationDate(), method);
    }
}

