/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.measure.fxopt.FxOptionScenarioMarketData;
import com.opengamma.strata.measure.fxopt.FxVanillaOptionMeasureCalculations;
import com.opengamma.strata.measure.fxopt.FxVanillaOptionMethod;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.fxopt.FxVanillaOption;
import com.opengamma.strata.product.fxopt.FxVanillaOptionTrade;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOptionTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FxVanillaOptionTradeCalculationFunction
implements CalculationFunction<FxVanillaOptionTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, FxVanillaOptionMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, FxVanillaOptionMeasureCalculations.DEFAULT::pv01RatesCalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, FxVanillaOptionMeasureCalculations.DEFAULT::pv01RatesCalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, FxVanillaOptionMeasureCalculations.DEFAULT::pv01RatesMarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, FxVanillaOptionMeasureCalculations.DEFAULT::pv01RatesMarketQuoteBucketed).put((Object)Measures.CURRENCY_EXPOSURE, FxVanillaOptionMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, FxVanillaOptionMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.VEGA_MARKET_QUOTE_BUCKETED, FxVanillaOptionMeasureCalculations.DEFAULT::vegaMarketQuoteBucketed).put((Object)Measures.RESOLVED_TARGET, (rt, smd, m, meth) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<FxVanillaOptionTrade> targetType() {
        return FxVanillaOptionTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(FxVanillaOptionTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(FxVanillaOptionTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrencyPair().getBase();
    }

    public FunctionRequirements requirements(FxVanillaOptionTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        FxVanillaOption product = trade.getProduct();
        CurrencyPair currencyPair = product.getCurrencyPair();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements((Set<Currency>)ImmutableSet.of((Object)currencyPair.getBase(), (Object)currencyPair.getCounter()));
        FxOptionMarketDataLookup optionLookup = (FxOptionMarketDataLookup)parameters.getParameter(FxOptionMarketDataLookup.class);
        FunctionRequirements optionReqs = optionLookup.requirements(currencyPair);
        return ratesReqs.combinedWith(optionReqs);
    }

    public Map<Measure, Result<?>> calculate(FxVanillaOptionTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedFxVanillaOptionTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        FxOptionMarketDataLookup optionLookup = (FxOptionMarketDataLookup)parameters.getParameter(FxOptionMarketDataLookup.class);
        FxOptionScenarioMarketData optionMarketData = optionLookup.marketDataView(scenarioMarketData);
        FxVanillaOptionMethod method = parameters.findParameter(FxVanillaOptionMethod.class).orElse(FxVanillaOptionMethod.BLACK);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ratesMarketData, optionMarketData, method));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedFxVanillaOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxVanillaOptionMethod method) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for FxVanillaOptionTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, ratesMarketData, optionMarketData, method));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedFxVanillaOptionTrade var1, RatesScenarioMarketData var2, FxOptionScenarioMarketData var3, FxVanillaOptionMethod var4);
    }
}

