/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.measure.fxopt.FxOptionScenarioMarketData;
import com.opengamma.strata.measure.fxopt.FxSingleBarrierOptionMeasureCalculations;
import com.opengamma.strata.measure.fxopt.FxSingleBarrierOptionMethod;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.product.fxopt.FxSingleBarrierOption;
import com.opengamma.strata.product.fxopt.FxSingleBarrierOptionTrade;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOptionTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class FxSingleBarrierOptionTradeCalculationFunction
implements CalculationFunction<FxSingleBarrierOptionTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, FxSingleBarrierOptionMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.PV01_CALIBRATED_SUM, FxSingleBarrierOptionMeasureCalculations.DEFAULT::pv01RatesCalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, FxSingleBarrierOptionMeasureCalculations.DEFAULT::pv01RatesCalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, FxSingleBarrierOptionMeasureCalculations.DEFAULT::pv01RatesMarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, FxSingleBarrierOptionMeasureCalculations.DEFAULT::pv01RatesMarketQuoteBucketed).put((Object)Measures.CURRENCY_EXPOSURE, FxSingleBarrierOptionMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, FxSingleBarrierOptionMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.VEGA_MARKET_QUOTE_BUCKETED, FxSingleBarrierOptionMeasureCalculations.DEFAULT::vegaMarketQuoteBucketed).put((Object)Measures.RESOLVED_TARGET, (rt, smd, m, meth) -> rt).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<FxSingleBarrierOptionTrade> targetType() {
        return FxSingleBarrierOptionTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(FxSingleBarrierOptionTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(FxSingleBarrierOptionTrade trade, ReferenceData refData) {
        return trade.getProduct().getCurrencyPair().getBase();
    }

    public FunctionRequirements requirements(FxSingleBarrierOptionTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        FxSingleBarrierOption product = trade.getProduct();
        CurrencyPair currencyPair = product.getCurrencyPair();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        FunctionRequirements ratesReqs = ratesLookup.requirements((Set<Currency>)ImmutableSet.of((Object)currencyPair.getBase(), (Object)currencyPair.getCounter()));
        FxOptionMarketDataLookup optionLookup = (FxOptionMarketDataLookup)parameters.getParameter(FxOptionMarketDataLookup.class);
        FunctionRequirements optionReqs = optionLookup.requirements(currencyPair);
        return ratesReqs.combinedWith(optionReqs);
    }

    public Map<Measure, Result<?>> calculate(FxSingleBarrierOptionTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedFxSingleBarrierOptionTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData ratesMarketData = ratesLookup.marketDataView(scenarioMarketData);
        FxOptionMarketDataLookup optionLookup = (FxOptionMarketDataLookup)parameters.getParameter(FxOptionMarketDataLookup.class);
        FxOptionScenarioMarketData optionMarketData = optionLookup.marketDataView(scenarioMarketData);
        FxSingleBarrierOptionMethod method = parameters.findParameter(FxSingleBarrierOptionMethod.class).orElse(FxSingleBarrierOptionMethod.BLACK);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, ratesMarketData, optionMarketData, method));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for FxSingleBarrierOptionTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, ratesMarketData, optionMarketData, method));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedFxSingleBarrierOptionTrade var1, RatesScenarioMarketData var2, FxOptionScenarioMarketData var3, FxSingleBarrierOptionMethod var4);
    }
}

