/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.fxopt.FxCalculationUtils;
import com.opengamma.strata.measure.fxopt.FxOptionScenarioMarketData;
import com.opengamma.strata.measure.fxopt.FxSingleBarrierOptionMethod;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.BlackFxSingleBarrierOptionTradePricer;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.product.fxopt.ResolvedFxSingleBarrierOptionTrade;
import java.time.LocalDate;

final class FxSingleBarrierOptionMeasureCalculations {
    public static final FxSingleBarrierOptionMeasureCalculations DEFAULT = new FxSingleBarrierOptionMeasureCalculations(BlackFxSingleBarrierOptionTradePricer.DEFAULT, ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final BlackFxSingleBarrierOptionTradePricer blackPricer;
    private final ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer trinomialTreePricer;

    FxSingleBarrierOptionMeasureCalculations(BlackFxSingleBarrierOptionTradePricer blackPricer, ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer trinomialTreePricer) {
        this.blackPricer = (BlackFxSingleBarrierOptionTradePricer)ArgChecker.notNull((Object)blackPricer, (String)"blackPricer");
        this.trinomialTreePricer = (ImpliedTrinomialTreeFxSingleBarrierOptionTradePricer)ArgChecker.notNull((Object)trinomialTreePricer, (String)"trinomialTreePricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount presentValue(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        if (method == FxSingleBarrierOptionMethod.TRINOMIAL_TREE) {
            return this.trinomialTreePricer.presentValue(trade, ratesProvider, FxCalculationUtils.checkTrinomialTreeVolatilities(volatilities));
        }
        return this.blackPricer.presentValue(trade, ratesProvider, FxCalculationUtils.checkBlackVolatilities(volatilities));
    }

    MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.parameterSensitivities(trade, ratesProvider, volatilities, method);
        return paramSens.total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.parameterSensitivities(trade, ratesProvider, volatilities, method);
        return paramSens.multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteSum(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.parameterSensitivities(trade, ratesProvider, volatilities, method);
        return MARKET_QUOTE_SENS.sensitivity(paramSens, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        CurrencyParameterSensitivities paramSens = this.parameterSensitivities(trade, ratesProvider, volatilities, method);
        return MARKET_QUOTE_SENS.sensitivity(paramSens, ratesProvider).multipliedBy(1.0E-4);
    }

    private CurrencyParameterSensitivities parameterSensitivities(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        if (method == FxSingleBarrierOptionMethod.TRINOMIAL_TREE) {
            return this.trinomialTreePricer.presentValueSensitivityRates(trade, ratesProvider, FxCalculationUtils.checkTrinomialTreeVolatilities(volatilities));
        }
        PointSensitivities pointSens = this.blackPricer.presentValueSensitivityRatesStickyStrike(trade, ratesProvider, FxCalculationUtils.checkBlackVolatilities(volatilities));
        return ratesProvider.parameterSensitivity(pointSens);
    }

    ScenarioArray<CurrencyParameterSensitivities> vegaMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        if (method == FxSingleBarrierOptionMethod.TRINOMIAL_TREE) {
            throw new IllegalArgumentException("FX single barrier option Trinomial Tree pricer does not currently support vega calculation");
        }
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.vegaMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    CurrencyParameterSensitivities vegaMarketQuoteBucketed(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        if (method == FxSingleBarrierOptionMethod.TRINOMIAL_TREE) {
            throw new IllegalArgumentException("FX single barrier option Trinomial Tree pricer does not currently support vega calculation");
        }
        BlackFxOptionVolatilities blackVols = FxCalculationUtils.checkBlackVolatilities(volatilities);
        PointSensitivities pointSens = this.blackPricer.presentValueSensitivityModelParamsVolatility(trade, ratesProvider, blackVols);
        return blackVols.parameterSensitivity(pointSens);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        CurrencyPair currencyPair = trade.getProduct().getCurrencyPair();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currencyExposure(trade, ratesMarketData.scenario(i).ratesProvider(), optionMarketData.scenario(i).volatilities(currencyPair), method));
    }

    MultiCurrencyAmount currencyExposure(ResolvedFxSingleBarrierOptionTrade trade, RatesProvider ratesProvider, FxOptionVolatilities volatilities, FxSingleBarrierOptionMethod method) {
        if (method == FxSingleBarrierOptionMethod.TRINOMIAL_TREE) {
            return this.trinomialTreePricer.currencyExposure(trade, ratesProvider, FxCalculationUtils.checkTrinomialTreeVolatilities(volatilities));
        }
        return this.blackPricer.currencyExposure(trade, ratesProvider, FxCalculationUtils.checkBlackVolatilities(volatilities));
    }

    CurrencyScenarioArray currentCash(ResolvedFxSingleBarrierOptionTrade trade, RatesScenarioMarketData ratesMarketData, FxOptionScenarioMarketData optionMarketData, FxSingleBarrierOptionMethod method) {
        return CurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currentCash(trade, ratesMarketData.scenario(i).getValuationDate(), method));
    }

    CurrencyAmount currentCash(ResolvedFxSingleBarrierOptionTrade trade, LocalDate valuationDate, FxSingleBarrierOptionMethod method) {
        if (method == FxSingleBarrierOptionMethod.TRINOMIAL_TREE) {
            return this.trinomialTreePricer.currentCash(trade, valuationDate);
        }
        return this.blackPricer.currentCash(trade, valuationDate);
    }
}

