/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.observable.QuoteId;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.pricer.fxopt.FxVolatilitySurfaceYearFractionParameterMetadata;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FxOptionVolatilitiesNode
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull")
    private final String label;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment spotDateOffset;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment expiryDateOffset;
    @PropertyDefinition(validate="notNull")
    private final ValueType quoteValueType;
    @PropertyDefinition(validate="notNull")
    private final QuoteId quoteId;
    @PropertyDefinition(validate="notNull")
    private final Tenor tenor;
    @PropertyDefinition(validate="notNull")
    private final Strike strike;
    private static final long serialVersionUID = 1L;

    public static FxOptionVolatilitiesNode of(CurrencyPair currencyPair, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment, ValueType quoteValueType, QuoteId quoteId, Tenor tenor, Strike strike) {
        DaysAdjustment expiryDateOffset = FxOptionVolatilitiesNode.expiryDateOffset(spotDateOffset);
        return new FxOptionVolatilitiesNode(currencyPair, quoteId.toString(), spotDateOffset, businessDayAdjustment, expiryDateOffset, quoteValueType, quoteId, tenor, strike);
    }

    private static DaysAdjustment expiryDateOffset(DaysAdjustment spotDateOffset) {
        ArgChecker.isTrue((boolean)spotDateOffset.getAdjustment().equals((Object)BusinessDayAdjustment.NONE), (String)"BusinessDayAdjustment in spotDateOffset must be NONE if expiryDateOffset is created from spotDateOffset");
        DaysAdjustment adj = spotDateOffset.toBuilder().days(-spotDateOffset.getDays()).build();
        return adj;
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.expiryDateOffset == null && builder.spotDateOffset != null) {
            builder.expiryDateOffset = FxOptionVolatilitiesNode.expiryDateOffset(builder.spotDateOffset);
        }
    }

    public FxVolatilitySurfaceYearFractionParameterMetadata metadata(ZonedDateTime valuationDateTime, DayCount dayCount, ReferenceData refData) {
        LocalDate valuationDate = valuationDateTime.toLocalDate();
        LocalDate spotDate = this.spotDateOffset.adjust(valuationDate, refData);
        LocalDate deliveryDate = this.businessDayAdjustment.adjust(spotDate.plus((TemporalAmount)this.tenor), refData);
        LocalDate expiryDate = this.expiryDateOffset.adjust(deliveryDate, refData);
        double timeToExpiry = dayCount.relativeYearFraction(valuationDate, expiryDate);
        return FxVolatilitySurfaceYearFractionParameterMetadata.of((double)timeToExpiry, (Tenor)this.tenor, (Strike)this.strike, (CurrencyPair)this.currencyPair);
    }

    public double timeToExpiry(ZonedDateTime valuationDateTime, DayCount dayCount, ReferenceData refData) {
        LocalDate valuationDate = valuationDateTime.toLocalDate();
        LocalDate spotDate = this.spotDateOffset.adjust(valuationDate, refData);
        LocalDate deliveryDate = this.businessDayAdjustment.adjust(spotDate.plus((TemporalAmount)this.tenor), refData);
        LocalDate expiryDate = this.expiryDateOffset.adjust(deliveryDate, refData);
        return dayCount.relativeYearFraction(valuationDate, expiryDate);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FxOptionVolatilitiesNode(CurrencyPair currencyPair, String label, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment, DaysAdjustment expiryDateOffset, ValueType quoteValueType, QuoteId quoteId, Tenor tenor, Strike strike) {
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)label, (String)"label");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        JodaBeanUtils.notNull((Object)expiryDateOffset, (String)"expiryDateOffset");
        JodaBeanUtils.notNull((Object)quoteValueType, (String)"quoteValueType");
        JodaBeanUtils.notNull((Object)quoteId, (String)"quoteId");
        JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
        JodaBeanUtils.notNull((Object)strike, (String)"strike");
        this.currencyPair = currencyPair;
        this.label = label;
        this.spotDateOffset = spotDateOffset;
        this.businessDayAdjustment = businessDayAdjustment;
        this.expiryDateOffset = expiryDateOffset;
        this.quoteValueType = quoteValueType;
        this.quoteId = quoteId;
        this.tenor = tenor;
        this.strike = strike;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public String getLabel() {
        return this.label;
    }

    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public DaysAdjustment getExpiryDateOffset() {
        return this.expiryDateOffset;
    }

    public ValueType getQuoteValueType() {
        return this.quoteValueType;
    }

    public QuoteId getQuoteId() {
        return this.quoteId;
    }

    public Tenor getTenor() {
        return this.tenor;
    }

    public Strike getStrike() {
        return this.strike;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxOptionVolatilitiesNode other = (FxOptionVolatilitiesNode)obj;
            return JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.label, (Object)other.label) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.expiryDateOffset, (Object)other.expiryDateOffset) && JodaBeanUtils.equal((Object)this.quoteValueType, (Object)other.quoteValueType) && JodaBeanUtils.equal((Object)this.quoteId, (Object)other.quoteId) && JodaBeanUtils.equal((Object)this.tenor, (Object)other.tenor) && JodaBeanUtils.equal((Object)this.strike, (Object)other.strike);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.label);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.quoteValueType);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.quoteId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strike);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("FxOptionVolatilitiesNode{");
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
        buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset)).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
        buf.append("expiryDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.expiryDateOffset)).append(',').append(' ');
        buf.append("quoteValueType").append('=').append(JodaBeanUtils.toString((Object)this.quoteValueType)).append(',').append(' ');
        buf.append("quoteId").append('=').append(JodaBeanUtils.toString((Object)this.quoteId)).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FxOptionVolatilitiesNode> {
        private CurrencyPair currencyPair;
        private String label;
        private DaysAdjustment spotDateOffset;
        private BusinessDayAdjustment businessDayAdjustment;
        private DaysAdjustment expiryDateOffset;
        private ValueType quoteValueType;
        private QuoteId quoteId;
        private Tenor tenor;
        private Strike strike;

        private Builder() {
        }

        private Builder(FxOptionVolatilitiesNode beanToCopy) {
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.label = beanToCopy.getLabel();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.expiryDateOffset = beanToCopy.getExpiryDateOffset();
            this.quoteValueType = beanToCopy.getQuoteValueType();
            this.quoteId = beanToCopy.getQuoteId();
            this.tenor = beanToCopy.getTenor();
            this.strike = beanToCopy.getStrike();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case 102727412: {
                    return this.label;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 508197748: {
                    return this.expiryDateOffset;
                }
                case 758636847: {
                    return this.quoteValueType;
                }
                case 664377527: {
                    return this.quoteId;
                }
                case 110246592: {
                    return this.tenor;
                }
                case -891985998: {
                    return this.strike;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case 102727412: {
                    this.label = (String)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 508197748: {
                    this.expiryDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 758636847: {
                    this.quoteValueType = (ValueType)newValue;
                    break;
                }
                case 664377527: {
                    this.quoteId = (QuoteId)newValue;
                    break;
                }
                case 110246592: {
                    this.tenor = (Tenor)newValue;
                    break;
                }
                case -891985998: {
                    this.strike = (Strike)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FxOptionVolatilitiesNode build() {
            FxOptionVolatilitiesNode.preBuild(this);
            return new FxOptionVolatilitiesNode(this.currencyPair, this.label, this.spotDateOffset, this.businessDayAdjustment, this.expiryDateOffset, this.quoteValueType, this.quoteId, this.tenor, this.strike);
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder label(String label) {
            JodaBeanUtils.notNull((Object)label, (String)"label");
            this.label = label;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder expiryDateOffset(DaysAdjustment expiryDateOffset) {
            JodaBeanUtils.notNull((Object)expiryDateOffset, (String)"expiryDateOffset");
            this.expiryDateOffset = expiryDateOffset;
            return this;
        }

        public Builder quoteValueType(ValueType quoteValueType) {
            JodaBeanUtils.notNull((Object)quoteValueType, (String)"quoteValueType");
            this.quoteValueType = quoteValueType;
            return this;
        }

        public Builder quoteId(QuoteId quoteId) {
            JodaBeanUtils.notNull((Object)quoteId, (String)"quoteId");
            this.quoteId = quoteId;
            return this;
        }

        public Builder tenor(Tenor tenor) {
            JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
            this.tenor = tenor;
            return this;
        }

        public Builder strike(Strike strike) {
            JodaBeanUtils.notNull((Object)strike, (String)"strike");
            this.strike = strike;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("FxOptionVolatilitiesNode.Builder{");
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("label").append('=').append(JodaBeanUtils.toString((Object)this.label)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("expiryDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.expiryDateOffset)).append(',').append(' ');
            buf.append("quoteValueType").append('=').append(JodaBeanUtils.toString((Object)this.quoteValueType)).append(',').append(' ');
            buf.append("quoteId").append('=').append(JodaBeanUtils.toString((Object)this.quoteId)).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", FxOptionVolatilitiesNode.class, CurrencyPair.class);
        private final MetaProperty<String> label = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"label", FxOptionVolatilitiesNode.class, String.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", FxOptionVolatilitiesNode.class, DaysAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", FxOptionVolatilitiesNode.class, BusinessDayAdjustment.class);
        private final MetaProperty<DaysAdjustment> expiryDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryDateOffset", FxOptionVolatilitiesNode.class, DaysAdjustment.class);
        private final MetaProperty<ValueType> quoteValueType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quoteValueType", FxOptionVolatilitiesNode.class, ValueType.class);
        private final MetaProperty<QuoteId> quoteId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quoteId", FxOptionVolatilitiesNode.class, QuoteId.class);
        private final MetaProperty<Tenor> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", FxOptionVolatilitiesNode.class, Tenor.class);
        private final MetaProperty<Strike> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", FxOptionVolatilitiesNode.class, Strike.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currencyPair", "label", "spotDateOffset", "businessDayAdjustment", "expiryDateOffset", "quoteValueType", "quoteId", "tenor", "strike"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case 102727412: {
                    return this.label;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 508197748: {
                    return this.expiryDateOffset;
                }
                case 758636847: {
                    return this.quoteValueType;
                }
                case 664377527: {
                    return this.quoteId;
                }
                case 110246592: {
                    return this.tenor;
                }
                case -891985998: {
                    return this.strike;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FxOptionVolatilitiesNode> beanType() {
            return FxOptionVolatilitiesNode.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<String> label() {
            return this.label;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<DaysAdjustment> expiryDateOffset() {
            return this.expiryDateOffset;
        }

        public MetaProperty<ValueType> quoteValueType() {
            return this.quoteValueType;
        }

        public MetaProperty<QuoteId> quoteId() {
            return this.quoteId;
        }

        public MetaProperty<Tenor> tenor() {
            return this.tenor;
        }

        public MetaProperty<Strike> strike() {
            return this.strike;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return ((FxOptionVolatilitiesNode)bean).getCurrencyPair();
                }
                case 102727412: {
                    return ((FxOptionVolatilitiesNode)bean).getLabel();
                }
                case 746995843: {
                    return ((FxOptionVolatilitiesNode)bean).getSpotDateOffset();
                }
                case -1065319863: {
                    return ((FxOptionVolatilitiesNode)bean).getBusinessDayAdjustment();
                }
                case 508197748: {
                    return ((FxOptionVolatilitiesNode)bean).getExpiryDateOffset();
                }
                case 758636847: {
                    return ((FxOptionVolatilitiesNode)bean).getQuoteValueType();
                }
                case 664377527: {
                    return ((FxOptionVolatilitiesNode)bean).getQuoteId();
                }
                case 110246592: {
                    return ((FxOptionVolatilitiesNode)bean).getTenor();
                }
                case -891985998: {
                    return ((FxOptionVolatilitiesNode)bean).getStrike();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

