/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.calc.marketdata.MarketDataConfig;
import com.opengamma.strata.calc.marketdata.MarketDataFunction;
import com.opengamma.strata.calc.marketdata.MarketDataRequirements;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.ValuationZoneTimeDefinition;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesDefinition;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesId;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.IntStream;

public class FxOptionVolatilitiesMarketDataFunction
implements MarketDataFunction<FxOptionVolatilities, FxOptionVolatilitiesId> {
    public MarketDataRequirements requirements(FxOptionVolatilitiesId id, MarketDataConfig marketDataConfig) {
        FxOptionVolatilitiesDefinition volatilitiesDefinition = (FxOptionVolatilitiesDefinition)marketDataConfig.get(FxOptionVolatilitiesDefinition.class, id.getName().getName());
        return MarketDataRequirements.builder().addValues(volatilitiesDefinition.volatilitiesInputs()).build();
    }

    public MarketDataBox<FxOptionVolatilities> build(FxOptionVolatilitiesId id, MarketDataConfig marketDataConfig, ScenarioMarketData marketData, ReferenceData refData) {
        FxOptionVolatilitiesDefinition volatilitiesDefinition = (FxOptionVolatilitiesDefinition)marketDataConfig.get(FxOptionVolatilitiesDefinition.class, id.getName().getName());
        ValuationZoneTimeDefinition zoneTimeDefinition = (ValuationZoneTimeDefinition)marketDataConfig.get(ValuationZoneTimeDefinition.class);
        int nScenarios = marketData.getScenarioCount();
        MarketDataBox valuationDates = marketData.getValuationDate();
        MarketDataBox<ZonedDateTime> valuationDateTimes = zoneTimeDefinition.toZonedDateTime((MarketDataBox<LocalDate>)valuationDates);
        int nParameters = volatilitiesDefinition.getParameterCount();
        ImmutableList inputs = (ImmutableList)volatilitiesDefinition.volatilitiesInputs().stream().map(q -> marketData.getValue((MarketDataId)q)).collect(Guavate.toImmutableList());
        ImmutableList vols = (ImmutableList)IntStream.range(0, nScenarios).mapToObj(scenarioIndex -> volatilitiesDefinition.volatilities((ZonedDateTime)valuationDateTimes.getValue(scenarioIndex), DoubleArray.of((int)nParameters, paramIndex -> (Double)((MarketDataBox)inputs.get(paramIndex)).getValue(scenarioIndex)), refData)).collect(Guavate.toImmutableList());
        return nScenarios > 1 ? MarketDataBox.ofScenarioValues((List)vols) : MarketDataBox.ofSingleValue((Object)vols.get(0));
    }

    public Class<FxOptionVolatilitiesId> getMarketDataIdType() {
        return FxOptionVolatilitiesId.class;
    }
}

