/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionSmileVolatilities;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.product.option.Barrier;
import com.opengamma.strata.product.option.BarrierType;
import com.opengamma.strata.product.option.SimpleConstantContinuousBarrier;

class FxCalculationUtils {
    private FxCalculationUtils() {
    }

    static BlackFxOptionVolatilities checkBlackVolatilities(FxOptionVolatilities volatilities) {
        if (volatilities instanceof BlackFxOptionVolatilities) {
            return (BlackFxOptionVolatilities)volatilities;
        }
        throw new IllegalArgumentException("FX option Black pricing requires BlackFxOptionVolatilities");
    }

    static BlackFxOptionSmileVolatilities checkVannaVolgaVolatilities(FxOptionVolatilities volatilities) {
        if (volatilities instanceof BlackFxOptionSmileVolatilities) {
            return (BlackFxOptionSmileVolatilities)volatilities;
        }
        throw new IllegalArgumentException("FX option Vanna Volga pricing requires BlackFxOptionSmileVolatilities");
    }

    static BlackFxOptionVolatilities checkTrinomialTreeVolatilities(FxOptionVolatilities volatilities) {
        if (volatilities instanceof BlackFxOptionVolatilities) {
            return (BlackFxOptionVolatilities)volatilities;
        }
        throw new IllegalArgumentException("FX option Trinomial Tree pricing requires BlackFxOptionVolatilities");
    }

    static boolean isBarrierBreached(Barrier barrier, CurrencyPair currencyPair, FxRateProvider rateProvider) {
        if (!(barrier instanceof SimpleConstantContinuousBarrier)) {
            throw new IllegalArgumentException(Messages.format((String)"Only SimpleConstantContinuousBarrier barrier is supported for FX Options, found {}", (Object)barrier.getClass().getSimpleName()));
        }
        SimpleConstantContinuousBarrier constantBarrier = (SimpleConstantContinuousBarrier)barrier;
        BarrierType barrierType = constantBarrier.getBarrierType();
        double barrierLevel = constantBarrier.getBarrierLevel();
        double spot = rateProvider.fxRate(currencyPair);
        return barrierType == BarrierType.DOWN ? spot <= barrierLevel : spot >= barrierLevel;
    }
}

