/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.option.SimpleStrike;
import com.opengamma.strata.market.surface.InterpolatedNodalSurface;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.SurfaceName;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.market.surface.interpolator.GridSurfaceInterpolator;
import com.opengamma.strata.market.surface.interpolator.SurfaceInterpolator;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesNode;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesSpecification;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionSurfaceVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification
implements FxOptionVolatilitiesSpecification,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxOptionVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ImmutableList<FxOptionVolatilitiesNode> nodes;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator timeInterpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator timeExtrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator timeExtrapolatorRight;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator strikeInterpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator strikeExtrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator strikeExtrapolatorRight;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        int nParams = this.nodes.size();
        for (int i = 0; i < nParams; ++i) {
            ArgChecker.isTrue((boolean)((FxOptionVolatilitiesNode)this.nodes.get(i)).getCurrencyPair().equals((Object)this.currencyPair), (String)"Currency pair must be the same");
            ArgChecker.isTrue((boolean)(((FxOptionVolatilitiesNode)this.nodes.get(i)).getStrike() instanceof SimpleStrike), (String)"Strike must be SimpleStrike");
            ArgChecker.isTrue((boolean)((FxOptionVolatilitiesNode)this.nodes.get(i)).getQuoteValueType().equals((Object)ValueType.BLACK_VOLATILITY), (String)"Quote value type must be BLACK_VOLATILITY");
        }
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.strikeExtrapolatorLeft = CurveExtrapolators.FLAT;
        builder.strikeExtrapolatorRight = CurveExtrapolators.FLAT;
        builder.timeExtrapolatorLeft = CurveExtrapolators.FLAT;
        builder.timeExtrapolatorRight = CurveExtrapolators.FLAT;
    }

    public BlackFxOptionSurfaceVolatilities volatilities(ZonedDateTime valuationDateTime, DoubleArray parameters, ReferenceData refData) {
        int nNodes = this.getParameterCount();
        ArgChecker.isTrue((parameters.size() == nNodes ? 1 : 0) != 0, (String)Messages.format((String)"size of parameters must be {}, but found {}", (Object[])new Object[]{nNodes, parameters.size()}));
        DoubleArray strikes = DoubleArray.of((int)nNodes, i -> ((FxOptionVolatilitiesNode)this.nodes.get(i)).getStrike().getValue());
        DoubleArray expiries = DoubleArray.of((int)nNodes, i -> ((FxOptionVolatilitiesNode)this.nodes.get(i)).timeToExpiry(valuationDateTime, this.dayCount, refData));
        ImmutableList paramMetadata = (ImmutableList)this.nodes.stream().map(node -> node.metadata(valuationDateTime, this.dayCount, refData)).collect(Guavate.toImmutableList());
        SurfaceMetadata metadata = Surfaces.blackVolatilityByExpiryStrike((SurfaceName)SurfaceName.of((String)this.name.getName()), (DayCount)this.dayCount).withParameterMetadata((List)paramMetadata);
        GridSurfaceInterpolator interp = GridSurfaceInterpolator.of((CurveInterpolator)this.timeInterpolator, (CurveExtrapolator)this.timeExtrapolatorLeft, (CurveExtrapolator)this.timeExtrapolatorRight, (CurveInterpolator)this.strikeInterpolator, (CurveExtrapolator)this.strikeExtrapolatorLeft, (CurveExtrapolator)this.strikeExtrapolatorRight);
        InterpolatedNodalSurface surface = InterpolatedNodalSurface.ofUnsorted((SurfaceMetadata)metadata, (DoubleArray)expiries, (DoubleArray)strikes, (DoubleArray)parameters, (SurfaceInterpolator)interp);
        return BlackFxOptionSurfaceVolatilities.of((FxOptionVolatilitiesName)this.name, (CurrencyPair)this.currencyPair, (ZonedDateTime)valuationDateTime, (Surface)surface);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification(FxOptionVolatilitiesName name, CurrencyPair currencyPair, DayCount dayCount, List<FxOptionVolatilitiesNode> nodes, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull(nodes, (String)"nodes");
        JodaBeanUtils.notNull((Object)timeInterpolator, (String)"timeInterpolator");
        JodaBeanUtils.notNull((Object)timeExtrapolatorLeft, (String)"timeExtrapolatorLeft");
        JodaBeanUtils.notNull((Object)timeExtrapolatorRight, (String)"timeExtrapolatorRight");
        JodaBeanUtils.notNull((Object)strikeInterpolator, (String)"strikeInterpolator");
        JodaBeanUtils.notNull((Object)strikeExtrapolatorLeft, (String)"strikeExtrapolatorLeft");
        JodaBeanUtils.notNull((Object)strikeExtrapolatorRight, (String)"strikeExtrapolatorRight");
        this.name = name;
        this.currencyPair = currencyPair;
        this.dayCount = dayCount;
        this.nodes = ImmutableList.copyOf(nodes);
        this.timeInterpolator = timeInterpolator;
        this.timeExtrapolatorLeft = timeExtrapolatorLeft;
        this.timeExtrapolatorRight = timeExtrapolatorRight;
        this.strikeInterpolator = strikeInterpolator;
        this.strikeExtrapolatorLeft = strikeExtrapolatorLeft;
        this.strikeExtrapolatorRight = strikeExtrapolatorRight;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FxOptionVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public ImmutableList<FxOptionVolatilitiesNode> getNodes() {
        return this.nodes;
    }

    public CurveInterpolator getTimeInterpolator() {
        return this.timeInterpolator;
    }

    public CurveExtrapolator getTimeExtrapolatorLeft() {
        return this.timeExtrapolatorLeft;
    }

    public CurveExtrapolator getTimeExtrapolatorRight() {
        return this.timeExtrapolatorRight;
    }

    public CurveInterpolator getStrikeInterpolator() {
        return this.strikeInterpolator;
    }

    public CurveExtrapolator getStrikeExtrapolatorLeft() {
        return this.strikeExtrapolatorLeft;
    }

    public CurveExtrapolator getStrikeExtrapolatorRight() {
        return this.strikeExtrapolatorRight;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification other = (BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal(this.nodes, other.nodes) && JodaBeanUtils.equal((Object)this.timeInterpolator, (Object)other.timeInterpolator) && JodaBeanUtils.equal((Object)this.timeExtrapolatorLeft, (Object)other.timeExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.timeExtrapolatorRight, (Object)other.timeExtrapolatorRight) && JodaBeanUtils.equal((Object)this.strikeInterpolator, (Object)other.strikeInterpolator) && JodaBeanUtils.equal((Object)this.strikeExtrapolatorLeft, (Object)other.strikeExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.strikeExtrapolatorRight, (Object)other.strikeExtrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.nodes);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeExtrapolatorRight);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeExtrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
        buf.append("timeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.timeInterpolator)).append(',').append(' ');
        buf.append("timeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorLeft)).append(',').append(' ');
        buf.append("timeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorRight)).append(',').append(' ');
        buf.append("strikeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.strikeInterpolator)).append(',').append(' ');
        buf.append("strikeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorLeft)).append(',').append(' ');
        buf.append("strikeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification> {
        private FxOptionVolatilitiesName name;
        private CurrencyPair currencyPair;
        private DayCount dayCount;
        private List<FxOptionVolatilitiesNode> nodes = ImmutableList.of();
        private CurveInterpolator timeInterpolator;
        private CurveExtrapolator timeExtrapolatorLeft;
        private CurveExtrapolator timeExtrapolatorRight;
        private CurveInterpolator strikeInterpolator;
        private CurveExtrapolator strikeExtrapolatorLeft;
        private CurveExtrapolator strikeExtrapolatorRight;

        private Builder() {
            BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.applyDefaults(this);
        }

        private Builder(BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification beanToCopy) {
            this.name = beanToCopy.getName();
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.dayCount = beanToCopy.getDayCount();
            this.nodes = beanToCopy.getNodes();
            this.timeInterpolator = beanToCopy.getTimeInterpolator();
            this.timeExtrapolatorLeft = beanToCopy.getTimeExtrapolatorLeft();
            this.timeExtrapolatorRight = beanToCopy.getTimeExtrapolatorRight();
            this.strikeInterpolator = beanToCopy.getStrikeInterpolator();
            this.strikeExtrapolatorLeft = beanToCopy.getStrikeExtrapolatorLeft();
            this.strikeExtrapolatorRight = beanToCopy.getStrikeExtrapolatorRight();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case -587914188: {
                    return this.timeInterpolator;
                }
                case -286652761: {
                    return this.timeExtrapolatorLeft;
                }
                case -290640004: {
                    return this.timeExtrapolatorRight;
                }
                case 815202713: {
                    return this.strikeInterpolator;
                }
                case -1176196724: {
                    return this.strikeExtrapolatorLeft;
                }
                case -2096699081: {
                    return this.strikeExtrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (FxOptionVolatilitiesName)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 104993457: {
                    this.nodes = (List)newValue;
                    break;
                }
                case -587914188: {
                    this.timeInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -286652761: {
                    this.timeExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case -290640004: {
                    this.timeExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                case 815202713: {
                    this.strikeInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -1176196724: {
                    this.strikeExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case -2096699081: {
                    this.strikeExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification build() {
            return new BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification(this.name, this.currencyPair, this.dayCount, this.nodes, this.timeInterpolator, this.timeExtrapolatorLeft, this.timeExtrapolatorRight, this.strikeInterpolator, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        }

        public Builder name(FxOptionVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder nodes(List<FxOptionVolatilitiesNode> nodes) {
            JodaBeanUtils.notNull(nodes, (String)"nodes");
            this.nodes = nodes;
            return this;
        }

        public Builder nodes(FxOptionVolatilitiesNode ... nodes) {
            return this.nodes((List<FxOptionVolatilitiesNode>)ImmutableList.copyOf((Object[])nodes));
        }

        public Builder timeInterpolator(CurveInterpolator timeInterpolator) {
            JodaBeanUtils.notNull((Object)timeInterpolator, (String)"timeInterpolator");
            this.timeInterpolator = timeInterpolator;
            return this;
        }

        public Builder timeExtrapolatorLeft(CurveExtrapolator timeExtrapolatorLeft) {
            JodaBeanUtils.notNull((Object)timeExtrapolatorLeft, (String)"timeExtrapolatorLeft");
            this.timeExtrapolatorLeft = timeExtrapolatorLeft;
            return this;
        }

        public Builder timeExtrapolatorRight(CurveExtrapolator timeExtrapolatorRight) {
            JodaBeanUtils.notNull((Object)timeExtrapolatorRight, (String)"timeExtrapolatorRight");
            this.timeExtrapolatorRight = timeExtrapolatorRight;
            return this;
        }

        public Builder strikeInterpolator(CurveInterpolator strikeInterpolator) {
            JodaBeanUtils.notNull((Object)strikeInterpolator, (String)"strikeInterpolator");
            this.strikeInterpolator = strikeInterpolator;
            return this;
        }

        public Builder strikeExtrapolatorLeft(CurveExtrapolator strikeExtrapolatorLeft) {
            JodaBeanUtils.notNull((Object)strikeExtrapolatorLeft, (String)"strikeExtrapolatorLeft");
            this.strikeExtrapolatorLeft = strikeExtrapolatorLeft;
            return this;
        }

        public Builder strikeExtrapolatorRight(CurveExtrapolator strikeExtrapolatorRight) {
            JodaBeanUtils.notNull((Object)strikeExtrapolatorRight, (String)"strikeExtrapolatorRight");
            this.strikeExtrapolatorRight = strikeExtrapolatorRight;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
            buf.append("timeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.timeInterpolator)).append(',').append(' ');
            buf.append("timeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorLeft)).append(',').append(' ');
            buf.append("timeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorRight)).append(',').append(' ');
            buf.append("strikeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.strikeInterpolator)).append(',').append(' ');
            buf.append("strikeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorLeft)).append(',').append(' ');
            buf.append("strikeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxOptionVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, FxOptionVolatilitiesName.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurrencyPair.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, DayCount.class);
        private final MetaProperty<ImmutableList<FxOptionVolatilitiesNode>> nodes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nodes", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, ImmutableList.class);
        private final MetaProperty<CurveInterpolator> timeInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeInterpolator", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> timeExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeExtrapolatorLeft", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> timeExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeExtrapolatorRight", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final MetaProperty<CurveInterpolator> strikeInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeInterpolator", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> strikeExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeExtrapolatorLeft", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> strikeExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeExtrapolatorRight", BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currencyPair", "dayCount", "nodes", "timeInterpolator", "timeExtrapolatorLeft", "timeExtrapolatorRight", "strikeInterpolator", "strikeExtrapolatorLeft", "strikeExtrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case -587914188: {
                    return this.timeInterpolator;
                }
                case -286652761: {
                    return this.timeExtrapolatorLeft;
                }
                case -290640004: {
                    return this.timeExtrapolatorRight;
                }
                case 815202713: {
                    return this.strikeInterpolator;
                }
                case -1176196724: {
                    return this.strikeExtrapolatorLeft;
                }
                case -2096699081: {
                    return this.strikeExtrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification> beanType() {
            return BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxOptionVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ImmutableList<FxOptionVolatilitiesNode>> nodes() {
            return this.nodes;
        }

        public MetaProperty<CurveInterpolator> timeInterpolator() {
            return this.timeInterpolator;
        }

        public MetaProperty<CurveExtrapolator> timeExtrapolatorLeft() {
            return this.timeExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> timeExtrapolatorRight() {
            return this.timeExtrapolatorRight;
        }

        public MetaProperty<CurveInterpolator> strikeInterpolator() {
            return this.strikeInterpolator;
        }

        public MetaProperty<CurveExtrapolator> strikeExtrapolatorLeft() {
            return this.strikeExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> strikeExtrapolatorRight() {
            return this.strikeExtrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getName();
                }
                case 1005147787: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getCurrencyPair();
                }
                case 1905311443: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getDayCount();
                }
                case 104993457: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getNodes();
                }
                case -587914188: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getTimeInterpolator();
                }
                case -286652761: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getTimeExtrapolatorLeft();
                }
                case -290640004: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getTimeExtrapolatorRight();
                }
                case 815202713: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getStrikeInterpolator();
                }
                case -1176196724: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getStrikeExtrapolatorLeft();
                }
                case -2096699081: {
                    return ((BlackFxOptionInterpolatedNodalSurfaceVolatilitiesSpecification)bean).getStrikeExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

