/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fx;

import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.fx.FxSingleMeasureCalculations;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.pricer.fx.DiscountingFxSingleTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.fx.ResolvedFxSingleTrade;

public class FxSingleTradeCalculations {
    public static final FxSingleTradeCalculations DEFAULT = new FxSingleTradeCalculations(DiscountingFxSingleTradePricer.DEFAULT);
    private final FxSingleMeasureCalculations calc;

    public FxSingleTradeCalculations(DiscountingFxSingleTradePricer tradePricer) {
        this.calc = new FxSingleMeasureCalculations(tradePricer);
    }

    public MultiCurrencyScenarioArray presentValue(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount presentValue(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.presentValue(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01CalibratedSum(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01CalibratedBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01CalibratedBucketed(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteSum(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01MarketQuoteSum(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteSum(trade, ratesProvider);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.pv01MarketQuoteBucketed(trade, lookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.pv01MarketQuoteBucketed(trade, ratesProvider);
    }

    public DoubleScenarioArray parSpread(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.parSpread(trade, lookup.marketDataView(marketData));
    }

    public double parSpread(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.parSpread(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.currencyExposure(trade, ratesProvider);
    }

    public MultiCurrencyScenarioArray currentCash(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, lookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currentCash(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.currentCash(trade, ratesProvider);
    }

    public ScenarioArray<FxRate> forwardFxRate(ResolvedFxSingleTrade trade, RatesMarketDataLookup lookup, ScenarioMarketData marketData) {
        return this.calc.forwardFxRate(trade, lookup.marketDataView(marketData));
    }

    public FxRate forwardFxRate(ResolvedFxSingleTrade trade, RatesProvider ratesProvider) {
        return this.calc.forwardFxRate(trade, ratesProvider);
    }
}

